package com.ovopark.privilege.common.utils;


import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Component
public class SessionManager {

	@Resource
	private RedisUtil redisUtil;

	/**
	 * 声明对象
	 */
	public static SessionManager sessionManager;

	/**
	 * 初始化
	 */
	@PostConstruct
	public void init() {
		sessionManager = this;
		sessionManager.redisUtil = this.redisUtil;
	}

	public static String getSession(String sessionId) {
		String data =  (String)sessionManager.redisUtil.get(sessionId);
		if (data != null){
			sessionManager.redisUtil.del(sessionId);
		}
		return data;
	}

	public static void removeSession(String sessionId) {
		sessionManager.redisUtil.del(sessionId);
	}
}
