package com.ovopark.privilege.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName: StringUtils
 * @Description: 字符串操作工具类
 */
public class StringUtils extends org.apache.commons.lang3.StringUtils {

  /**
   * <p> Title: </p> . <p> Description: </p>
   */
  private StringUtils() {

  }

  /**
   * @param str 待判断字符串
   * @return boolean 返回类型
   * @Title: isBlank
   * @Description: 判断字符串是否为空(此处代表null 、 空格或 " ")
   */
  public static boolean isBlank(String str) {
    return org.apache.commons.lang3.StringUtils.isBlank(str);
  }

  /**
   * @param str 待判断字符串
   * @return boolean 返回类型
   * @Title: isEmpty
   * @Description: 判断字符串是否为空(此处代表null或 " ")
   */
  public static boolean isEmpty(String str) {
    return org.apache.commons.lang3.StringUtils.isEmpty(str);
  }

  /**
   * @param str 待判断字符串
   * @return boolean 返回类型
   * @Title: isNotEmpty
   * @Description: 判断字符串是否为空(此处代表null或 " ")
   */
  public static boolean isNotEmpty(String str) {
    return !isEmpty(str);
  }

  /**
   * 判断信息是否为空
   */
  public static boolean isNotEmpty(Object obj) {
    if (obj != null && !isEmpty(obj.toString())) {
      return true;
    }
    return false;
  }

  /**
   * @param str 待判断字符串
   * @return boolean 返回类型
   * @Title: isAllLowerCase
   * @Description: 判断字符串是否全为小写字母
   */
  public static boolean isAllLowerCase(String str) {
    return StringUtils.isAllLowerCase(str);
  }

  /**
   * @param str 待判断字符串
   * @return boolean 返回类型
   * @Title: isAllUpperCase
   * @Description: 判断字符串是否全为大写字母
   */
  public static boolean isAllUpperCase(String str) {
    return StringUtils.isAllUpperCase(str);
  }

  /**
   * @param str 待判断字符串
   * @return boolean 返回类型
   * @Title: isAlpha
   * @Description: 判断字符串是否全为unicode字母
   */
  public static boolean isAlpha(String str) {
    return org.apache.commons.lang3.StringUtils.isAlpha(str);
  }

  /**
   * @param str 待判断字符串
   * @return boolean 返回类型
   * @Title: isNumeric
   * @Description: 判断字符串是否全为数字
   */
  public static boolean isNumeric(String str) {
    return org.apache.commons.lang3.StringUtils.isNumeric(str);
  }

  /**
   * @param array 待操作数组
   * @return String 返回类型
   * @Title: join
   * @Description: 把数组中的元素连接为字符串
   */
  public static String join(Object[] array) {
    return org.apache.commons.lang3.StringUtils.join(array);
  }

  /**
   * @param array     待操作数组
   * @param separator 连接符
   * @return String 返回类型
   * @Title: join
   * @Description: 把数组中的元素连接为字符串
   */
  public static String join(Object[] array, String separator) {
    return org.apache.commons.lang3.StringUtils.join(array, separator);
  }

  /**
   * @param col 待操作集合
   * @return String
   * @Title: join
   * @Description: 把集合中的元素连接为字符串
   */
  @SuppressWarnings("rawtypes")
  public static String join(Collection col) {
    return org.apache.commons.lang3.StringUtils.join(col, ",");
  }

  /**
   * @param col       待操作集合
   * @param separator 连接符
   * @return String
   * @Title: join
   * @Description: 把集合中的元素连接为字符串
   */
  @SuppressWarnings("rawtypes")
  public static String join(Collection col, String separator) {
    return org.apache.commons.lang3.StringUtils.join(col, separator);
  }

  /**
   * @param text        待替换字符串
   * @param searchText  旧值
   * @param replaceText 新值
   * @return String 返回类型
   * @Title: replace
   * @Description: 用新值代替字符串中指定的旧值
   */
  public static String replace(String text, String searchText, String replaceText) {
    return org.apache.commons.lang3.StringUtils.replace(text, searchText, replaceText);
  }

  /**
   * @param str 待操作字符串
   * @return String[] 返回类型
   * @Title: split
   * @Description: 分解字符串为数组(分解符为空格)
   */
  public static String[] split(String str) {
    return org.apache.commons.lang3.StringUtils.split(str);
  }

  /**
   * @param str       待操作字符串
   * @param separator 分解符
   * @return String[] 返回类型
   * @Title: split
   * @Description: 分解字符串为数组
   */
  public static String[] split(String str, String separator) {
    return org.apache.commons.lang3.StringUtils.split(str, separator);
  }

  /**
   * @param str 待操作字符串
   * @return String 返回类型
   * @Title: trim
   * @Description: 去除字符串两端空格
   */
  public static String trim(String str)  {
    return org.apache.commons.lang3.StringUtils.trim(str);
  }

  /**
   * @param str 待操作字符串
   * @return String 返回类型
   * @Title: defaultString
   * @Description: 避免返回null值，若str为null返回"".
   */
  public static String defaultString(String str) {
    return org.apache.commons.lang3.StringUtils.defaultString(str);
  }

  /**
   * @return String[]
   * @Title: p
   * @Description: 全排列
   * @since 0.2
   */
  public static String[] p(String str) {
    String[] r = {str.substring(0, 1)};
    String[] strs = bindP(r, str.substring(1));

    return strs;
  }

  /**
   * @param r 已排列
   * @param l 未排列
   * @return String[]
   * @Title: bindP
   * @Description: 对指定元素和集合进行排列
   * @since 0.2
   */
  private static String[] bindP(String[] r, String l) {
    List<String> lst = new ArrayList<String>();
    if (isBlank(l)) {
      return r;
    } else if (l.length() == 1) {
      for (int i = 0; i < r.length; i++) {
        Collections.addAll(lst, insertP(r[i], l.charAt(0)));
      }
    } else if (l.length() > 1) {
      for (int i = 0; i < r.length; i++) {
        String[] strs = bindP(insertP(r[i], l.charAt(0)), l.substring(1));
        Collections.addAll(lst, strs);
      }
    }
    String[] strs = {};
    return lst.toArray(strs);
  }

  /**
   * @return String[]
   * @Title: insertP
   * @Description:
   * @since 0.2
   */
  private static String[] insertP(String r, char l) {
    String[] strs = new String[r.length() + 1];
    for (int i = 0; i <= r.length(); i++) {
      strs[i] = insert(r, i, l);
    }
    return strs;
  }

  /**
   * @return String 返回类型
   * @Title: insert
   * @Description: 字符串中插入字符
   * @since 0.2
   */
  public static String insert(String r, int i, char l) {
    return r.substring(0, i) + l + r.substring(i);
  }

  /**
   * @return String 返回类型
   * @Title: remove
   * @Description: 移出字符串中指定位置的字符
   * @since 0.2
   */
  public static String remove(String str, int i) {
    return str.substring(0, i) + str.substring(i + 1);
  }

  /**
   * @return Object[] 返回类型
   * @Title: toArray
   * @Description: 字符串按字符转换为数组
   * @since 0.2
   */
  public static String[] toArray(String str) {
    if (isBlank(str)) {
      return null;
    }
    String[] strs = new String[str.length()];
    for (int i = 0; i < strs.length; i++) {
      strs[i] = String.valueOf(str.charAt(i));
    }

    return strs;
  }

  /**
   * @param str 字符串
   * @param arr 字符数组
   * @return boolean
   * @Title: containsAny
   * @Description: 判断字符串中是否包含字符数组中的字符
   */

  public static boolean containsAny(String str, char[] arr) {
    return org.apache.commons.lang3.StringUtils.containsAny(str, arr);
  }

  /**
   * 判断手机号
   */
  public static boolean isMobileNO(String mobiles) {
    String str = "^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";
    Pattern p = Pattern.compile(str);
    Matcher m = p.matcher(mobiles);
    return m.matches();
  }

  /**
   * 判断邮箱
   */
  public static boolean isEmail(String email) {
    String str = "^([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\.][A-Za-z]{2,3}([\\.][A-Za-z]{2})?$";
    Pattern p = Pattern.compile(str);
    Matcher m = p.matcher(email);
    return m.matches();
  }

  /**
   * 判断身份证
   */
  public static boolean isId(String Id) {
    String str = "^\\d{15}$|^\\d{17}(?:\\d|x|X)$";
    Pattern p = Pattern.compile(str);
    Matcher m = p.matcher(Id);
    return m.matches();
  }

  /**
   * 判断固定电话
   */
  public static boolean isTelephone(String telephone) {
    String str = "(\\(\\d{3,4}\\)|\\d{3,4}-|\\s)?\\d{8}";
    Pattern p = Pattern.compile(str);
    Matcher m = p.matcher(telephone);
    return m.matches();
  }

  public static List<String> StringToList(String hpzl) {
    List<String> listHpzl = new ArrayList<String>();
    String[] hpzls = hpzl.split(",");
    for (String b : hpzls) {
      listHpzl.add(b);
    }
    return listHpzl;
  }

  /**
   * @param str 待编码字符串
   * @param enc encode
   * @return String 返回类型
   * @throws UnsupportedEncodingException 不支持的编码异常
   * @Title: encode
   * @Description: 对字符串中的中文进行编码
   */
  public static String encode(final String str, final String enc)
      throws UnsupportedEncodingException {

    String fmt  = "[\u4e00-\u9fa5]";
    Pattern p = Pattern.compile(fmt);
    Matcher m = p.matcher(str);
    StringBuffer sb = new StringBuffer();
    while (m.find()) {
      m.appendReplacement(sb, URLEncoder.encode(m.group(), enc));
    }
    m.appendTail(sb);
    return sb.toString();
  }

  /**
   * @return String 返回类型
   * @Title: getType
   * @Description: 报警服务器端给发送的message 中 找出 type 类型
   */
  public static String getType(String message) {
    String type = null;
    if (message != null && !"".equals(message)) {
      int start = (message.indexOf("\"type\":\""));
      int end = (message.indexOf("}"));
      type = (String) (message.subSequence(start, end));
      if (type != null && !"".equals(type)) {
        type = type.substring("\"type\":\"".length(), type.length() - 1);
      }
    }
    return type;
  }

  /**
   * @return String 返回类型
   * @Title: getType
   * @Description: 报警服务器端给发送的message 中 找出 type 类型
   */
  public static String getKeyValue(String message, String key) {
    String value = null;
    if (message != null && !"".equals(message)) {
      String[] sep = message.split("\"" + key + "\":");
      if (sep.length > 1) {
        String s = sep[1];
        value = (s.substring(1, s.indexOf(",") - 1));
      }
    }
    return value;
  }

  /**
   * 15位身份证号码转18位
   */
  public static String idCard15To18(String personIDCode) {
    if ((personIDCode == null) || (personIDCode.trim().length() != 15)) {
      return personIDCode;
    }
    String id17 = personIDCode.substring(0, 6) + "19" + personIDCode.substring(6, 15);

    char[] code = {'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    int[] factor = {0, 2, 4, 8, 5, 10, 9, 7, 3, 6, 1, 2, 4, 8, 5, 10, 9, 7};
    int[] idcd = new int[18];

    for (int i = 1; i < 18; i++) {
      int j = 17 - i;
      idcd[i] = Integer.parseInt(id17.substring(j, j + 1));
    }

    int sum = 0;
    for (int i = 1; i < 18; i++) {
      sum += idcd[i] * factor[i];
    }
    int remainder = sum % 11;
    String lastCheckBit = String.valueOf(code[remainder]);
    return id17 + lastCheckBit;
  }

  /**
   * 全角切换半角
   */
  public static String full2Half(String fullStr) {
    if (isEmpty(fullStr)) {
      return fullStr;
    }
    char[] c = fullStr.toCharArray();
    for (int i = 0; i < c.length; i++) {
      if (c[i] >= 65281 && c[i] <= 65374) {
        c[i] = (char) (c[i] - 65248);
      } else if (c[i] == 12288) { // 空格
        c[i] = (char) 32;
      }
    }
    return new String(c);
  }

  /**
   * 去除字符串中所包含的空格（包括:空格(全角，半角)、制表符、换页符等）
   */
  public static String removeAllBlank(String s) {
    String result = "";
    if (null != s && !"".equals(s)) {
      result = s.replaceAll("[　*| *| *|//s*]*", "");
    }
    return result;
  }

  /**
   * 首字母转小写
   */
  public static String toLowerCaseFirstOne(String s) {
    if (Character.isLowerCase(s.charAt(0))) {
      return s;
    } else {
      return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }
  }

  /**
   * 首字母转大写
   */
  public static String toUpperCaseFirstOne(String s) {
    if (Character.isUpperCase(s.charAt(0))) {
      return s;
    } else {
      return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
  }

  /**
   * 金额格式转换，三位加逗号
   */
  public static String moneyFormat(String money) {
    if (isEmpty(money)) {
      return money;
    }
    DecimalFormat df = new DecimalFormat("0.00");

    String head = "-".equals(money.substring(0, 1)) ? "-" : "";
    money = "-".equals(money.substring(0, 1)) ? money.substring(1) : money;

    money = df.format(Double.parseDouble(money.toString()));
    // int i=money.length();
    String inter = money.substring(0, money.indexOf("."));
    String doubl = money.substring(money.indexOf("."));
    char[] tempInter = new char[inter.length()];
    StringBuilder temp = new StringBuilder("");
    for (int j = 0; j < inter.length(); j++) {
      char c = inter.charAt(inter.length() - j - 1);
      tempInter[j] = c;
    }
    for (int i = 0; i < tempInter.length; i++) {
      if (i != 0 && i % 3 == 0) {
        temp.append(",");
      }
      temp.append(tempInter[i]);
    }
    StringBuilder result = new StringBuilder("");
    for (int l = 0; l < temp.length(); l++) {
      char c = temp.charAt(temp.length() - l - 1);
      result.append(c);
    }
    return head + result.toString() + doubl;
  }

  public static String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "mail", "h", "i", "j",
      "k", "l", "m", "n",
      "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6",
      "7", "8",
      "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R",
      "S", "T",
      "U", "V", "W", "X", "Y", "Z"};

  // 获取num位随机字符
  public static String randomCreator(int num) {
    StringBuilder sBuilder = new StringBuilder();
    String uuid = UUID.randomUUID().toString().replace("-", "");
    for (int i = 0; i < num; i++) {
      String str = uuid.substring(i * 4, i * 4 + 4);
      int x = Integer.parseInt(str, 16);
      sBuilder.append(chars[x % 0x3E]);
    }
    return sBuilder.toString();
  }

  public static String arrayToString(Integer[][] a) {
    StringBuilder sBuilder = new StringBuilder("[");
    int col;
    int row;
    for (row = 0; row < a.length; row++) {
      sBuilder.append("[");
      for (col = 0; col < a[0].length; col++) {
        sBuilder.append(a[row][col]);
        if (col < a[0].length - 1) {
          sBuilder.append(",");
        }
      }
      sBuilder.append("]");
      if (row < a.length - 1) {
        sBuilder.append(",");
      }
    }
    sBuilder.append("]");
    return sBuilder.toString();
  }

  /**
   * 字符串转集合
   * @param string
   * @return
   */
  public static List<Integer> stringToList(String string){
    List<Integer> list = new ArrayList<>();
    if (StringUtils.isNotBlank(string)) {
      // 处理设备详情ID
      String[] array = StringUtils.split(string, ",");
      for (String s : array) {
        list.add(Integer.parseInt(s.trim()));
      }
    }
    return list;
  }

  /**
   * 根据逗号分割的字符串获取id列表
   * @param idStr
   * @return
   */
  public static List<Integer> createList(String idStr) {
    List<Integer> result = new ArrayList<>();
    if (idStr != null) {
      String[] array = idStr.split(",");
      for (String id : array) {
        if(org.apache.commons.lang3.StringUtils.isNotBlank(id)){
          result.add(Integer.parseInt(id));
        }
      }
    }
    return result;
  }
}
