package com.ovopark.privilege.common.utils;


import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Splitter;
import com.ovopark.privilege.common.constant.ThirdPartyCodeConstant;
import com.ovopark.privilege.common.exception.CommonException;
import com.ovopark.privilege.common.response.BaseResult;
import com.ovopark.privilege.common.response.ExceptionEnum;
import com.ovopark.privilege.config.MyConfig;
import com.ovopark.privilege.model.mo.TokenCreateMo;
import com.ovopark.privilege.model.vo.GetTokenValue;
import com.ovopark.privilege.model.vo.TokenValue;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Slf4j
public class TokenUtils {

    private static String ovoparkSsoUrl = MyConfig.getOvoparkSsoServerUrl();

    final static String shopwebsalt="kedacom.com";

    private static final String createTokenUrl = "/ovopark-sso/token/create";

    private static final String reFreshTokenUrl = "/ovopark-sso/token/reFreshToken";

    private static final String parseTokenUrl = "/ovopark-sso/token/parseToken";

    private static final String logoutByTokenUrl = "/ovopark-sso/token/logOutByToken";

    private static final String logoutByUserIdUrl = "/ovopark-sso/token/logOutByUserId";

    /**
     * 生成token
     */
    public static TokenValue getToken(Integer loginType, Integer userId) {
        RestTemplate restTemplate = new RestTemplate();
        String url = ovoparkSsoUrl + createTokenUrl;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        TokenCreateMo parameter = new TokenCreateMo();
        parameter.setLoginType(loginType);
        parameter.setUserId(userId);
        HttpEntity<TokenCreateMo> request = new HttpEntity<>(parameter, headers);
        ResponseEntity<GetTokenValue> response = restTemplate.postForEntity( url, request , GetTokenValue.class );
        GetTokenValue data = response.getBody();
        if (data==null){
            log.error("用戶id:{},loginType:{},調用{}失敗,返回結果{}",userId,loginType,url,response.toString());
            throw new CommonException(ExceptionEnum.PARAM_ERROR);
        }
        if (!data.isError()){
            return data.getData();
        }else {
            // 解析code
            throw pareCodeToCommonException(data.getCode());
        }
    }

    /**
     * 刷新token
     */
    public static TokenValue reFreshToken(String  token) {
        HttpResponse ovoResult = HttpUtil.createGet(ovoparkSsoUrl + reFreshTokenUrl+"?token=" + token).timeout(3000).execute();
        if (ovoResult == null || ovoResult.getStatus()!=200 || StringUtils.isBlank(ovoResult.body())){
            log.error("调用sso失败");
            throw new CommonException(ExceptionEnum.ERROR);
        }
        BaseResult<TokenValue> tokenValueBaseResult = null;
        try {
            tokenValueBaseResult = JsonUtils.objectMapper.readValue(ovoResult.body(), new TypeReference<BaseResult<TokenValue>>() {
            });
        } catch (JsonProcessingException e) {
            log.error("json转换异常",e);
            throw new CommonException(ExceptionEnum.ERROR);
        }
        if (!tokenValueBaseResult.getIsError()){
            return tokenValueBaseResult.getData();
        }else {
            // 解析code
            throw pareCodeToCommonException(tokenValueBaseResult.getCode());
        }
    }

    /**
     * 获取用户id
     */
    public static String getUserId(String ticket){
        try {
            if(ticket.contains(" ")) {
                ticket=getToken(ticket);
            }
            // 解密
            byte[] decryptResult = AesUtil.decrypt(ticket, shopwebsalt);
            String result=new String(decryptResult);
            //System.out.println("解密后：" +result);
            //24988,jia,f379eaf3c831b04de153469d1bec345e
            String id=result.split(",")[0];
            return id;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 获取用户id
     */
    public static Integer getNewUserId(String authenticator){
        String token = null;
        List<String> list= Splitter.on(" ").splitToList(authenticator);
        if(list.size()>0){
            token = list.get(0);
        }
        // 解析token 获取用户id
        return parseToken(token).getUserId();
    }

    /**
     * 解析token
     */
    public static String getToken(String authenticator){
        try {
            List<String> list= Splitter.on(" ").splitToList(authenticator);
            if(list.size()>0){
                return list.get(0);
            }
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 解析token
     * @param token code
     * @return TokenValue
     */
    public static TokenValue parseToken(String token){
        HttpResponse ovoResult = HttpUtil.createGet(ovoparkSsoUrl + parseTokenUrl+"?token=" + token).timeout(3000).execute();
        if (ovoResult == null || ovoResult.getStatus()!=200 || StringUtils.isBlank(ovoResult.body())){
            log.error("调用sso失败");
            throw new CommonException(ExceptionEnum.ERROR);
        }
        BaseResult<TokenValue> tokenValueBaseResult = null;
        try {
            tokenValueBaseResult = JsonUtils.objectMapper.readValue(ovoResult.body(), new TypeReference<BaseResult<TokenValue>>() {
            });
        } catch (JsonProcessingException e) {
            log.error("json转换异常",e);
            throw new CommonException(ExceptionEnum.ERROR);
        }
        if (!tokenValueBaseResult.getIsError()){
            return tokenValueBaseResult.getData();
        }else {
            // 解析code
            throw pareCodeToCommonException(tokenValueBaseResult.getCode());
        }
    }

    /**
     * 解析code
     * @param code
     * @return
     */
    private static CommonException pareCodeToCommonException(String code){
        switch (code){
            case ThirdPartyCodeConstant
                    .OvoSsoCodeConstant.TOKEN_NOT_EXIT:
                return new CommonException(ExceptionEnum.TOKEN_NOT_EXIT);
            case     ThirdPartyCodeConstant
                    .OvoSsoCodeConstant.TOKEN_EXPIRATION:
                return new CommonException(ExceptionEnum.TOKEN_EXPIRATION);
            default:
                return new CommonException(ExceptionEnum.ERROR);
        }
    }

    /**
     * 登出token
     */
    public static boolean logoutByToken(String token){
        HttpResponse ovoResult = HttpUtil.createGet(ovoparkSsoUrl + logoutByTokenUrl+"?token=" + token).timeout(3000).execute();
        if (ovoResult == null || ovoResult.getStatus()!=200 || StringUtils.isBlank(ovoResult.body())){
            log.error("调用sso失败");
            throw new CommonException(ExceptionEnum.ERROR);
        }
        BaseResult<TokenValue> tokenValueBaseResult = null;
        try {
            tokenValueBaseResult = JsonUtils.objectMapper.readValue(ovoResult.body(), new TypeReference<BaseResult<TokenValue>>() {
            });
        } catch (JsonProcessingException e) {
            log.error("json转换异常",e);
            throw new CommonException(ExceptionEnum.ERROR);
        }
        if (!tokenValueBaseResult.getIsError()){
            return true;
        }else {
            // 解析code
            throw pareCodeToCommonException(tokenValueBaseResult.getCode());
        }
    }

    /**
     * 登出用户所有token
     */
    public static boolean logoutByUserId(Integer userId){
        HttpResponse ovoResult = HttpUtil.createGet(ovoparkSsoUrl + logoutByUserIdUrl+"?userId=" + userId).timeout(3000).execute();
        if (ovoResult == null || ovoResult.getStatus()!=200 || StringUtils.isBlank(ovoResult.body())){
            log.error("调用sso失败");
            throw new CommonException(ExceptionEnum.ERROR);
        }
        BaseResult<TokenValue> tokenValueBaseResult = null;
        try {
            tokenValueBaseResult = JsonUtils.objectMapper.readValue(ovoResult.body(), new TypeReference<BaseResult<TokenValue>>() {
            });
        } catch (JsonProcessingException e) {
            log.error("json转换异常",e);
            throw new CommonException(ExceptionEnum.ERROR);
        }
        if (!tokenValueBaseResult.getIsError()){
            return true;
        }else {
            // 解析code
            throw pareCodeToCommonException(tokenValueBaseResult.getCode());
        }
    }

}
