package com.ovopark.privilege.config;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;

import java.util.Locale;

/**
 * Created by xuxing on 2019/2/20
 */
@Configuration
public class LocaleConfig {
  @Bean
  public ResourceBundleMessageSource messageSource() {
    Locale.setDefault(Locale.CHINESE);
    ResourceBundleMessageSource source = new ResourceBundleMessageSource();
    source.setBasenames("i18n/messages");// name of the resource bundle
    source.setUseCodeAsDefaultMessage(true);
    source.setDefaultEncoding("UTF-8");
    return source;
  }
  /**
   * 获取不到messageSource 可以采用此方法
   */
//  public String getMessage(String result, Locale locale) {
//    ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
//    messageSource.setCacheSeconds(-1);
//    messageSource.setDefaultEncoding(StandardCharsets.UTF_8.name());
//    messageSource.setBasenames("/i18n/messages");
//
//    String message = "";
//    try {
//      message = messageSource.getMessage(result, null, locale);
//    } catch (Exception e) {
//      e.printStackTrace();
//      //log.error("parse message error! ", e);
//    }
//    return message;
//  }
}
