package com.ovopark.privilege.config;

import com.ovopark.privilege.common.utils.StringUtils;
import lombok.Data;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;

/**
 * @author jimson
 *
 * 这里的配置文件都是从yml中获取
 */
@Data
@Configuration
public class MyConfig {

    public static HashMap<String,String> map = new HashMap<>();

    private static final String OVOPARK_SSO_SERVER_URL = "ovoparkSsoServerUrl";

    public static final String WEBSOCKET_URL = "websocketUrl";

    public static void setOvoparkSsoServerUrl(String value){
        if (StringUtils.isNotBlank(value)){
            map.put(OVOPARK_SSO_SERVER_URL,value);
        }
    }

    public static String getOvoparkSsoServerUrl(){
        return map.get(OVOPARK_SSO_SERVER_URL);
    }

    public static void setWebsocketUrl(String value){
        if (StringUtils.isNotBlank(value)){
            map.put(WEBSOCKET_URL,value);
        }
    }

    public static String getWebsocketUrl(){
        return map.get(WEBSOCKET_URL);
    }

}
