package com.ovopark.privilege.controller;

import com.ovopark.privilege.common.response.BaseResult;
import com.ovopark.privilege.common.support.LocalStorageUtils;
import com.ovopark.privilege.service.ProjectsService;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import java.util.Map;

/**
 * @author wxb
 * @Title: PlansController
 * @Description: 方案接口
 * @date 2020/10/13 16:16
 **/

@RestController
@RequestMapping("/plan")
public class PlansController {

    @Resource
    private ProjectsService projectsService;

    /** 
     * @description: 新增方案
     * @param: [parameter]
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2020/10/13 16:28
     */ 
    @PostMapping("/savePlan")
    public BaseResult<Boolean> savePlan (@RequestBody Map<String, Object> parameter){
        // 方案名称
        String planName = (String) parameter.get("planName");
        // 权限
        String privilegeIds = (String) parameter.get("privilegeIds");
        // 获取用户ID
        Integer userId = LocalStorageUtils.getStorageInfo().getUserId();
        Boolean success = projectsService.saveProject(userId, planName, privilegeIds);
        if (!success) {
            return BaseResult.error();
        }
        return BaseResult.success();
    }

    /**
     * @description: 覆盖方案
     * @param: [parameter]
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2020/10/13 16:28
     */
    @PostMapping("/updatePlan")
    public BaseResult<Boolean> updatePlan (@RequestBody Map<String, Object> parameter){
        // 方案id
        Integer planId = (Integer) parameter.get("planId");
        // 方案名称
        String planName = (String) parameter.get("planName");
        // 权限
        String privilegeIds = (String) parameter.get("privilegeIds");
        // 获取用户ID
        Integer userId = LocalStorageUtils.getStorageInfo().getUserId();
        Boolean success = projectsService.updateProject(userId, planId, planName, privilegeIds);
        if (!success) {
            return BaseResult.error();
        }
        return BaseResult.success();
    }

    /** 
     * @description: 删除方案
     * @param: [planId]
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2020/10/20 16:25
     */ 
    @GetMapping("/deletePlan")
    public BaseResult<Boolean> deletePlan (Integer planId){
        Boolean success = projectsService.deletePlan(planId);
        if (!success) {
            return BaseResult.error();
        }
        return BaseResult.success();
    }
}
