package com.ovopark.privilege.controller;

import com.ovopark.privilege.common.response.BaseResult;
import com.ovopark.privilege.common.response.ExceptionEnum;
import com.ovopark.privilege.common.support.LocalStorageUtils;
import com.ovopark.privilege.model.entity.UpdateRoleMo;
import com.ovopark.privilege.model.pojo.RolesPojo;
import com.ovopark.privilege.service.RolesService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 角色信息表 前端控制器
 * </p>
 *
 * @author wxb
 * @since 2020-09-21
 */
@RestController
@RequestMapping("/role")
public class RolesController {

    @Resource
    private RolesService rolesService;

    /** 
     * @description: 角色列表--角色管理页面
     * @param: []
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.util.List<com.ovopark.privilege.server.model.entity.Role>>
     * @author wxb
     * @date: 2020/9/21 16:21
     */ 
    @GetMapping("/getRoleList")
    public BaseResult<List<RolesPojo>> getRoleList(){
        // 获取用户ID
        Integer userId = LocalStorageUtils.getStorageInfo().getUserId();
        // 获取用户groupId
        Integer groupId = LocalStorageUtils.getStorageInfo().getGroupId();
        if (userId == null){
            return BaseResult.error(ExceptionEnum.INVALID_TOKEN);
        }
        return BaseResult.success(rolesService.getRoleList(userId, groupId));
    }

    /** 
     * @description: 通过企业id获取对应的角色列表--用户管理页面
     * @param: []
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>>
     * @author wxb
     * @date: 2020/9/24 14:07
     */ 
    @GetMapping("/getRoleListByGroup")
    public BaseResult<List<RolesPojo>> getRoleListByGroup(Integer groupId){
        // 获取用户ID
        Integer userId = LocalStorageUtils.getStorageInfo().getUserId();
        if (userId == null){
            return BaseResult.error(ExceptionEnum.INVALID_TOKEN);
        }
        return BaseResult.success(rolesService.getRoleListByGroup(userId, groupId));

    }

    /**
     * @description: 更新角色
     * @param: [parameter]
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>>
     * @author wxb
     * @date: 2020/10/28 13:05
     */
    @PostMapping("/updateRole")
    public BaseResult<Boolean> updateRole(@RequestBody UpdateRoleMo parameter){
        // 获取用户ID
        Integer userId = LocalStorageUtils.getStorageInfo().getUserId();
        // 获取用户groupId
        Integer groupId = LocalStorageUtils.getStorageInfo().getGroupId();
        if (userId == null){
            return BaseResult.error(ExceptionEnum.INVALID_TOKEN);
        }
        if (parameter.getRole().getRoleName() == null){
            return BaseResult.paramError();
        }
        if (parameter.getRole().getGroupId() == null){
            parameter.getRole().setGroupId(groupId);
        }
        Boolean success = rolesService.updateRole(userId, parameter.getRole(),parameter.getPrivilegeIds());
        if (!success) {
            return BaseResult.error();
        }
        return BaseResult.success();
    }

    /**
     * @description: 同步更新角色
     * @param: [parameter]
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2020/11/11 15:07
     */
    @PostMapping("/synUpdateRole")
    public BaseResult<Boolean> synUpdateRole(@RequestBody UpdateRoleMo parameter){
        // 获取用户ID
        Integer userId = LocalStorageUtils.getStorageInfo().getUserId();
        // 获取用户groupId
        Integer groupId = LocalStorageUtils.getStorageInfo().getGroupId();
        if (userId == null){
            return BaseResult.error(ExceptionEnum.INVALID_TOKEN);
        }
        if (parameter.getRole().getRoleName() == null){
            return BaseResult.paramError();
        }
        if (parameter.getRole().getGroupId() == null){
            parameter.getRole().setGroupId(groupId);
        }
        Boolean success = rolesService.synUpdateRole(userId, parameter.getRole(),parameter.getPrivilegeIds());
        if (!success) {
            return BaseResult.error();
        }
        return BaseResult.success();
    }

    /** 
     * @description: 删除角色
     * @param: [roleId]
     * @return: com.ovopark.privilege.server.common.response.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2020/10/28 15:02
     */ 
    @GetMapping("/deleteRole")
    public BaseResult<Boolean> deleteRole(Integer roleId){
        if (roleId == null || roleId == 1 || roleId ==2){
            BaseResult.paramError();
        }
        // 获取用户ID
        Integer userId = LocalStorageUtils.getStorageInfo().getUserId();
        if (userId == null){
            return BaseResult.error(ExceptionEnum.INVALID_TOKEN);
        }
        Boolean success = rolesService.deleteRole(userId, roleId);
        if (!success) {
            return BaseResult.error();
        }
        return BaseResult.success();
    }

}

