package com.ovopark.privilege.listener;

import com.ovopark.privilege.config.MyConfig;
import com.ovopark.privilege.service.SysConfigCacheService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Order(2)
@Component
public class AppStartFun implements ApplicationRunner {

	@Resource
	SysConfigCacheService sysConfigCacheService;

	@Resource
	private MyConfig myConfig;

	@Value("${myconfig.server-url.ovopark-sso::#{null}}")
	private String ovoparkSsoServerUrl;

	@Value("${myconfig.shopweb.websocket-url::#{null}}")
	private String websocketUrl;

	@Override
	public void run(ApplicationArguments args){
		sysConfigCacheService.reload();
		yml2memory();
	}

	private void yml2memory(){
		myConfig.setOvoparkSsoServerUrl(ovoparkSsoServerUrl);
		myConfig.setWebsocketUrl(websocketUrl);
	}
}

