package com.ovopark.privilege.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ovopark.privilege.model.entity.Privileges;
import com.ovopark.privilege.model.pojo.PrivilegesPojo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 权限信息表 Mapper 接口
 * </p>
 *
 * @author wxb
 * @since 2020-09-01
 */
public interface PrivilegesMapper extends BaseMapper<Privileges> {

    /**
     * @description: 获取企业的所有权限
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:18
     */
    List<PrivilegesPojo> getPrivilegesByEnterpriseId(@Param("enterpriseId")Integer enterpriseId);

    /**
     * @description: 获取企业菜单
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:18
     */
    List<PrivilegesPojo> getOpenMenusByEnterpriseId(@Param("enterpriseId")Integer enterpriseId);

    /**
     * @description: 获取用户权限列表
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:18
     */
    List<PrivilegesPojo> getPrivilegesByUserIdAndGroupId(@Param("userId")Integer userId, @Param("groupId")Integer groupId);

    /**
     * @description: 获取用户的菜单
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:18
     */
    List<PrivilegesPojo> getOpenMenusByUserId(@Param("userId")Integer userId);

    /**
     * @description: 获取企业菜单和权限
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/22 18:39
     */
    List<PrivilegesPojo> getMenusPrivilegesByEnterpriseId(@Param("enterpriseId")Integer enterpriseId);

    /** 
     * @description: 获取用户的指定权限
     * @param: [userId, privilegeId]
     * @return: com.ovopark.privilege.model.pojo.PrivilegesPojo
     * @author wxb
     * @date: 2020/11/14 15:53
     */ 
    PrivilegesPojo getPrivilegeByUserIdAndPrivilegeId(@Param("userId")Integer userId, @Param("privilegeId")Integer privilegeId);

}
