package com.ovopark.privilege.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ovopark.privilege.model.entity.UserRole;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface UserRoleMapper extends BaseMapper<UserRole> {

    /**
     * @description:
     * @param: [roleId]
     * @return: java.lang.Integer
     * @author wxb
     * @date: 2020/9/22 9:44
     */
    Integer getCountByRoleId(@Param("roleId")Integer roleId);

    /**
     * @description:
     * @param: [roleId, groupId]
     * @return: java.lang.Integer
     * @author wxb
     * @date: 2020/9/22 9:47
     */
    Integer getCountByRoleIdAndGroupId(@Param("roleId")Integer roleId, @Param("groupId")Integer groupId);

    /** 
     * @description: 查询用户设置的角色
     * @param: [userId, groupId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/23 13:16
     */ 
    List<Integer> getRoleIdsByUser(@Param("userId")Integer userId, @Param("groupId")Integer groupId);

    /** 
     * @description: 根据权限获取用户id
     * @param: [roleId, groupId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 10:02
     */ 
    List<Integer> getUserIdsByRole(@Param("roleId")Integer roleId, @Param("groupId")Integer groupId);
}
