package com.ovopark.privilege.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("is_enterprise_groups")
public class Enterprise extends Model<Enterprise> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 企业id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 企业名
     */
    private String name;

    /**
     * 企业编码
     */
    private String code;

    /**
     * 系统名称
     */
    private String systemName;

    /**
     * logo地址
     */
    private String logoPath;

    /**
     * 拼音名称
     */
    private String pyName;

    /**
     * 简称
     */
    private String shortName;

    private Integer hasLogo = 0;

    /**
     * 是否认证通过  0：未审核/审核中  1：通过  2:未通过
     */
    private Integer isPass = 0;

    /**
     * 所属二级行业id
     */
    private Integer industryId;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 营业开始时间 HH:mm
     */
    private String startWorkTime;

    /**
     * 营业结束时间 HH:mm
     */
    private String endWorkTime;

    /**
     * 企业拥有最多门店数限制
     */
    private Integer depCountLimit = 1;

    /**
     * 认证不通过理由
     */
    private String content;

    /**
     * 企业用户密码过期时间(天)
     */
    private Integer passwordExpireDays;

    /**
     * 创建时间
     */
    private Date createTime;

    private String contact;

    /**
     * 创建人id
     */
    private Integer createrId;

    private Long tenantId;

    private String insurancePhone;

    private Integer isManager = 0;

    private Integer isForShow = 0;

    /**
     * 有效时间
     */
    private Date validateDate;

    /**
     * 邮箱
     */
    private String email;

    private String nationalCode = "86";

    private Integer customerId;

    /**
     * 登录是否需要短信验证（0未配置1已配置）
     */
    private Integer needSms;

}
