package com.ovopark.privilege.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 菜单表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("is_modules_privileges")
public class Privileges extends Model<Privileges>  implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	/**
	 * 上级id
	 */
	private Integer parentId;

	/**
	 * 权限名称
	 */
	private String privilegeName;

	/**
	 * 权限描述
	 */
	private String privilegeDesc;

	/**
	 * 拼音名称
	 */
	private String pyName;

	/**
	 * 组织架构id APP定制模块使用
	 */
	private Integer enterpriseId;

	/**
	 * 权限类型0子模块1页面权限2操作权限
	 */
	private Integer type;

	/**
	 * 缩略图
	 */
	private String thumbUrl;

	/**
	 * 是否只为app模块 1是
	 */
	private Integer isApp;

	/**
	 * 是否只为web模块 1是
	 */
	private Integer isWeb;

	/**
	 * 产品id
	 */
	private Integer productId;

	/**
	 * 是否只为root模块 1是
	 */
	private Integer isRoot;

	/**
	 * 第三方应用名称
	 */
	private String name;

	/**
	 * 应用地址
	 */
	private String url;

	/**
	 * 创建时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime createTime;

}
