package com.ovopark.privilege.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wxb
 * @Title: UserDepartment
 * @Description: 门店角色人员表
 * @date 2020/10/14 13:49
 **/

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("is_user_department")
public class UserDepartment extends Model<UserDepartment> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 门店id
     */
    private Integer departmentId;

    /**
     * 角色id
     */
    private Integer roleId;

    /**
     * 企业id
     */
    private Integer groupId;

    /**
     * 创建时间
     */
    private Date createTime;

}
