package com.ovopark.privilege.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @description: 用户企业表
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/10/28 16:17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("is_user_enterprise")
public class UserEnterprise extends Model<UserEnterprise> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 企业id
     */
    private Integer enterpriseId;

    /**
     * 父级id
     */
    private Integer parentId;

    /**
     * 创建者id
     */
    private Integer createId;

    /**
     * 创建时间
     */
    private Date createTime;

    private Date validateDate;

    private Date quitTime;

    private Integer hasScoreConfig;

    private Integer exceptScoreRank;

    private Integer isDefault;

    private Integer isDel;

    private Integer isFrozen;

}