package com.ovopark.privilege.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 用户表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("is_users")
public class Users extends Model<Users> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 用户帐号
     */
    private String userName;

    /**
     * 显示名称
     */
    private String showName;

    /**
     * 企业id
     */
    private Integer groupId;

    /**
     * 用户密码
     */
    private String password;

    /**
     * 用户的部门权限集合
     */
    private Integer deptIds;

    /**
     * 电话
     */
    private String phone;

    /**
     * 移动电话
     */
    private String mobilePhone;

    /**
     * 邮箱
     */
    private String mail;

    /**
     * 区域语言
     */
    private String localelan;

    /**
     * 未读报表数
     */
    private Integer unread = 0;

    /**
     * 创建时间
     */
    private LocalDateTime validateDate;

    /**
     * 激活码
     */
    private String activateCode;

    /**
     * 上级用户的id
     */
    private Integer pId;

    /**
     * 创建者的id
     */
    private Integer createrId;

    /**
     * 用户权限
     */
    private String privileges;

    /**
     * 是否是自注册用户
     */
    private Integer isRegisterUser = 0;

    /**
     * 客流情况选择项
     */
    private String indicator;

    private Date createTime;

    /**
     * 密码更新时间
     */
    private Date passwdUpdateTime;

    private Integer userOrganId;

    /**
     * 新增字段手机APP中是否是单点登录
     */
    private Integer isSingleSign = 1;

    /**
     * 新增字段手机号码是否激活,邮箱是否已经激活
     */
    private Integer isPhoneActivate = 0;

    private Integer isMailActivate = 0;

    /**
     * 工号
     */
    private String employeeNumber;

    /**
     * 0正常 1删除
     */
    private Integer isDel = 0;

    /**
     * 拼音名
     */
    private String pyName;

    private Integer isAssign = 1;

    private Integer isAgency = 0;

    private int hasThumb = 0;

    private Long thumbUpdateTime;

    /**
     * 0未配置积分项 1已配置
     */
    private Integer hasScoreConfig = 0;

    /**
     * 0参与积分排名 1不参与积分排名
     */
    private Integer exceptScoreRank = 0;

    /**
     * 创建者姓名
     */
    private Integer creater;

    /**
     * 0正常1被冻结
     */
    private Integer isFrozen = 0;

    /**
     * 登陆时间
     */
    private Date loginTime;

    /**
     * 钉钉用户id
     */
    private String dingdingUserId;

    /**
     * 国家地区码
     */
    private String nationalCode = "86";

    private String thumbUrl;

    /**
     * 员工头像
     */
    private String staffImageUrl;

    private Integer isSysAdmin = 0;

    /**
     * 登录是否需要短信验证码验证(0未配置1以配置)
     */
    private Integer needSms;

}
