package com.ovopark.privilege.model.pojo;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 权限表
 */
@Data
public class PrivilegesPojo {

    /**
     * ID
     */
    private Integer id;

    /**
     * 上级ID
     */
    private Integer parentId;

    /**
     * 权限名
     */
    private String privilegeName;

    /**
     * 权限描述
     */
    private String privilegeDesc;

    /**
     * 是否只为app模块 1是
     */
    private Integer isApp;

    /**
     * 是否只为web模块 1是
     */
    private Integer isWeb;

    /**
     * 权限类型0子模块1页面权限2操作权限
     */
    private Integer type;

    /**
     * 产品id
     */
    private Integer productId;

    /**
     * 第三方应用名称
     */
    private String name;

    /**
     * 应用地址
     */
    private String url;

    /**
     * 图标
     */
    private String picUrl;

    /**
     * 缩略图地址
     */
    private String thumbUrl;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    /**
     * 子菜单
     */
    private List<PrivilegesPojo> children;

}
