package com.ovopark.privilege.model.pojo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ovopark.privilege.model.entity.Roles;
import com.ovopark.privilege.model.vo.DepIdAndNameVo;
import com.ovopark.privilege.model.vo.MenusPrivilegesVo;
import lombok.Data;

import java.util.List;

/**
 * @author wxb
 * @Title: RolesPojo
 * @Description: 角色
 * @date 2020/9/21 17:18
 **/
@Data
public class RolesPojo {

    /**
     * 角色ID
     */
    private Integer id;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 角色权限
     */
    private String privileges;

    /**
     * 企业id
     */
    private Integer groupId;

    /**
     * 应用到门店 0:不应用 1应用
     */
    private Integer applyToDept;

    @JsonProperty("pId")
    private Integer pId;

    private Integer isGrades;

    private Integer userCount;

    /**
     * 角色权限
     */
    private List<MenusPrivilegesVo> rolePrivileges;

    /**
     * 子级
     */
    private List<Roles> childRoles;

    /**
     * 父级
     */
    private RolesPojo belongGrade;

    /**
     * 角色分配的 门店ID
     */
    private List<DepIdAndNameVo> depIdAndNameList;
}
