package com.ovopark.privilege.service;


import com.ovopark.privilege.model.entity.EnterprisePrivileges;

import java.util.List;

/**
 * <p>
 * 企业权限信息表 服务类
 * </p>
 *
 * @author wxb
 * @since 2020-09-01
 */
public interface EnterprisePrivilegesService {

    /**
     * @description: 删除企业权限 根据企业id
     * @param: [enterpriseId]
     * @return: void
     * @author wxb
     * @date: 2020/9/17 15:05
     */
    void deleteEnterprisePrivileges(Integer enterpriseId);

    /**
     * @description: 添加企业权限
     * @param: [enterprisePrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/9/17 15:05
     */
    void insertEnterprisePrivileges(EnterprisePrivileges enterprisePrivileges);

    /**
     * @description: 批量保存企业权限
     * @param: [enterprisePrivilegesList]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/9/17 15:05
     */
    Boolean batchInsertEnterprisePrivileges(List<EnterprisePrivileges> enterprisePrivilegesList);

    /**
     * @description: 获取企业权限
     * @param: [enterpriseId, privilegeId]
     * @return: com.ovopark.privilege.server.model.entity.EnterprisePrivileges
     * @author wxb
     * @date: 2020/9/17 15:05
     */
    EnterprisePrivileges getEnterprisePrivilegesByEnterpriseIdAndPrivilegeId(Integer enterpriseId, Integer privilegeId);

    /** 
     * @description: 根据企业id获取权限的id列表
     * @param: [enterpriseId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/9/24 15:00
     */ 
    List<Integer> getPrivilegeIdsByEnterpriseId(Integer enterpriseId);

    /**
     * @description: 批量查询企业权限
     * @param: [privilegeIdList]
     * @return: java.util.List<com.ovopark.privilege.model.entity.EnterprisePrivileges>
     * @author wxb
     * @date: 2020/11/24 20:13
     */
    List<EnterprisePrivileges> getEnterprisePrivilegesByPrivilegeIds(List<Integer> privilegeIdList);

    /**
     * @description: 批量删除企业权限
     * @param: [privilegesPojoList]
     * @return: void
     * @author wxb
     * @date: 2020/11/24 19:53
     */
    void batchDeleteEnterprisePrivileges (List<EnterprisePrivileges> enterprisePrivileges);

    /**
     * @description: 获取企业的权限
     * @param: [enterpriseId]
     * @return: java.util.List<com.ovopark.privilege.model.entity.EnterprisePrivileges>
     * @author wxb
     * @date: 2020/11/24 20:28
     */
    List<EnterprisePrivileges> getEnterprisePrivilegesByEnterpriseId(Integer enterpriseId);

}
