package com.ovopark.privilege.service;

import com.ovopark.privilege.model.vo.CheckUserLoginVo;
import com.ovopark.privilege.model.vo.LoginUser;
import com.ovopark.privilege.model.vo.MobileLoginUser;
import com.ovopark.privilege.model.vo.TokenValue;

/**
 * <p>
 * 用户登录接口
 * </p>
 *
 * @author wxb
 * @since 2020-09-10
 */
public interface LoginService {

    /**
     * @description: 用户登录
     * @param: [userName, password, groupId, loginType]
     * @return: com.ovopark.privilege.server.model.vo.LoginUser
     * @author wxb
     * @date: 2020/9/17 15:06
     */
    LoginUser login(String userName, String password, Integer groupId, Integer loginType, String phone, String msgCheckCode);

    /**
     * @description: 移动端用户登录
     * @param: [userName, password, groupId, loginType, phone, msgCheckCode]
     * @return: com.ovopark.privilege.server.model.vo.MobileLoginUser
     * @author wxb
     * @date: 2020/11/5 14:03
     */
    MobileLoginUser mobileLogin(String userName, String password, Integer groupId, Integer loginType, String phone, String msgCheckCode);

    /**
     * @description: 刷新用户token
     * @param: [token]
     * @return: com.ovopark.privilege.server.model.vo.TokenValue
     * @author wxb
     * @date: 2020/9/17 15:06
     */
    TokenValue reFreshToken(String token);
    
    /** 
     * @description: 退出
     * @param: [userId]
     * @return: void
     * @author wxb
     * @date: 2020/9/27 17:14
     */ 
    boolean logout(String token);

    /**
     * @description: 校验用户
     * @param: [userId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/9/28 15:26
     */
    Boolean checkUserLogin(Integer userId);

    /**
     * 判断用户是否可以登录 并返回一些用户字段
     * @param userId 用户id
     * @return CheckUserLoginVo
     */
    CheckUserLoginVo getCheckUserLoginVo(Integer userId);

    /**
     * @description: 校验token 获取过期时间
     * @param: [token]
     * @return: com.ovopark.privilege.server.model.vo.CheckTokenVo
     * @author wxb
     * @date: 2020/10/13 14:29
     */
    TokenValue getTokenValue(String token);

    TokenValue getUserTokenValueByOldToken(String oldToken);
}
