package com.ovopark.privilege.service;


import com.ovopark.privilege.model.entity.Privileges;
import com.ovopark.privilege.model.mo.RoleIdAndDepIdsMo;
import com.ovopark.privilege.model.pojo.PrivilegesPojo;
import com.ovopark.privilege.model.vo.*;
import com.ovopark.privilege.pojo.UserPrivilegesPojo;
import com.ovopark.privilege.pojo.UsersPojo;

import java.util.List;

/**
 * <p>
 * 权限信息表 服务类
 * </p>
 *
 * @author wxb
 * @since 2020-09-01
 */
public interface PrivilegesService {

    /**
     * @description: 菜单树形结构
     * @param: [privileges]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/10/21 14:23
     */
    List<PrivilegesPojo> getPrivilegesTree (List<PrivilegesPojo> privileges);

    /** 
     * @description: 设置权限对应的产品
     * @param: [privileges]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/10/21 14:33
     */ 
    List<MenusPrivilegesVo> setProduct (List<PrivilegesPojo> privileges);

    /** 
     * @description: 根据id获取权限
     * @param: [privilegeId]
     * @return: com.ovopark.privilege.server.model.pojo.PrivilegesPojo
     * @author wxb
     * @date: 2020/10/13 19:56
     */ 
    PrivilegesPojo getPrivilegesPojoById(Integer privilegeId);

    /**
     * @description: 获取所有的权限
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:00
     */
    List<PrivilegesPojo> getAll();

    /**
     * @description: 获取企业的所有权限
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:01
     */
    List<PrivilegesPojo> getPrivilegesByEnterpriseId(Integer enterpriseId);

    /**
     * @description: 获取用户权限列表
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:02
     */
    List<PrivilegesPojo> getPrivilegesByUserIdAndGroupId(Integer userId, Integer groupId);

    /**
     * @description: 获取企业菜单 子模块和页面菜单
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:02
     */
    List<PrivilegesPojo> getOpenMenusByEnterpriseId(Integer enterpriseId);

    /**
     * @description: 获取用户的菜单 子模块和页面菜单
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:13
     */
    List<PrivilegesPojo> getOpenMenusByUserId(Integer userId);

    /**
     * @description: 获取用户权限
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:02
     */
    List<PrivilegesPojo> getPrivilegesByUser(Integer userId, Integer groupId);

    /**
     * @description: 获取WEB首页菜单权限
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/10/29 19:34
     */
    List<MenusPrivilegesVo> getMenus(Integer userId, Integer groupId);

    /**
     * @description: 获取权限
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:02
     */
    List<PrivilegesPojo> getWebPrivileges(Integer userId, Integer groupId);

    /**
     * @description: 获取用户所属权限菜单
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:02
     */
    List<MenusPrivilegesVo> getMenusPrivileges(Integer userId, Integer groupId);

    /** 
     * @description: 获取用户订阅的产品
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentProduct>
     * @author wxb
     * @date: 2020/10/29 10:41
     */ 
    List<UserRecentProductVo> getUserRecentProduct(Integer userId);

    /** 
     * @description: 保存用户订阅的产品
     * @param: [userId, groupId, productIds]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.UserRecentProductVo>
     * @author wxb
     * @date: 2020/10/29 10:54
     */
    Boolean saveUserRecentProduct(Integer userId, String productIds);

    /**
     * @description: 查询子级权限列表
     * @param: [parentId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:03
     */
    List<PrivilegesPojo> getPrivilegesByParentId(Integer parentId);

    /**
     * @description: 保存企业权限
     * @param: [enterpriseId, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/9/17 15:03
     */
    Boolean saveEnterprisePrivilege(Integer enterpriseId, String privilegeIds);

    /** 
     * @description: 同步保存企业权限
     * @param: [enterpriseId, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/10 17:22
     */ 
    Boolean synSaveEnterprisePrivilege(Integer enterpriseId, String privilegeIds);

    /** 
     * @description: 根据权限名获取新权限
     * @param: [privilegeName]
     * @return: com.ovopark.privilege.server.model.entity.Privileges
     * @author wxb
     * @date: 2020/11/10 18:39
     */ 
    Privileges getPrivilegesByPrivilegeName(String privilegeName);

    /** 
     * @description: 获取子权限
     * @param: [parentId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Privileges>
     * @author wxb
     * @date: 2020/11/10 18:53
     */ 
    List<Privileges> getPrivilegeListByParentId(Integer parentId);

    /**
     * @description: 获取企业的开发菜单
     * @param: [enterpriseId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/11/6 9:59
     */
    List<MenusPrivilegesVo> getEnterpriseOpenMenus(Integer enterpriseId);

    /**
     * @description: 获取所有的菜单 开放菜单
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/17 15:04
     */
    List<PrivilegesPojo> getAllMenus();

    /**
     * @description: 获取开放菜单
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/9/17 15:04
     */
    List<MenusPrivilegesVo> getOpenMenus();

    /** 
     * @description: 获取方案权限
     * @param: [planId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/10/13 19:53
     */
    List<MenusPrivilegesVo> getPlanPrivileges(Integer planId);

    /**
     * @description: 获取权限列表根据方案id
     * @param: [planId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/10/15 13:22
     */
    List<PrivilegesPojo> getPrivilegesByPlanId(Integer planId);

    /**
     * @description: 获取开放菜单
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/9/17 15:04
     */
    List<PrivilegesPojo> getUserOpenMenus();

    /**
     * @description: 获取用户有权限的菜单
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/9/17 15:04
     */
    List<PrivilegesPojo> getUserOpenMenus(Integer userId);

    /**
     * @description: 获取用户的菜单和对应权限列表
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.PrivilegesVo>
     * @author wxb
     * @date: 2020/9/18 15:26
     */
    List<MenusPrivilegesVo> getMenuPrivileges(Integer enterpriseId);

    /**
     * @description: 获取用户的菜单和对应权限列表
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/9/22 15:57
     */
    List<PrivilegesPojo> getUserMenusPrivileges(Integer userId);

    /**
     * @description: 获取企业菜单和权限
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/9/22 20:02
     */
    List<PrivilegesPojo> getEnterpriseMenusPrivileges(Integer groupId);

    /** 
     * @description: 获取所有的菜单和权限
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/22 16:01
     */ 
    List<PrivilegesPojo> getAllMenusPrivileges();

    /** 
     * @description: 获取企业菜单和权限
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/9/22 18:36
     */ 
    List<PrivilegesPojo> getMenusPrivilegesByEnterpriseId(Integer enterpriseId);

    /**
     * @description: 获取用户的菜单和权限
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/10/12 14:43
     */
    List<PrivilegesPojo> getMenuPrivilegesByUser(Integer userId, Integer groupId);

    /** 
     * @description: 保存用户权限
     * @param: [userId, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/9/24 14:47
     */
    void saveUserPrivileges(Integer userId, List<Integer> privilegeIds, Integer enterpriseId, boolean underEnterprise);

    /**
     * @description: 同步保存用户权限
     * @param: [userId, privilegeIds, enterpriseId, underEnterprise]
     * @return: void
     * @author wxb
     * @date: 2020/11/10 20:07
     */
    void synSaveUserPrivilege(Integer userId, List<Integer> privilegeIds, Integer enterpriseId, boolean underEnterprise);

    /** 
     * @description: 获取角色权限
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/10/12 15:10
     */ 
    RolePrivilegeVo getRolePrivilege(Integer userId, Integer groupId);
    
    /** 
     * @description: 获取权限列表
     * @param: [privilegeIdList]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/10/21 14:16
     */ 
    List<PrivilegesPojo> batchGetPrivilegeListByIds(List<Integer> privilegeIdList);

    /**
     * @description: 更新 用户角色权限
     * @param: [userId, groupId, roleList, roleDepStr, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/23 14:54
     */ 
    Boolean updateRolePrivilege(Integer userId, Integer groupId, List<Integer> roleList, List<RoleIdAndDepIdsMo> roleDepStr, List<Integer> privilegeIds);

    /**
     * @description: 同步更新 用户角色权限
     * @param: [userId, groupId, roleList, roleDepStr, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/10 19:56
     */
    Boolean synUpdateRolePrivilege(Integer userId, Integer groupId, List<Integer> privilegeIds);

    /**
     * @description: 获取新的权限id
     * @param: [oldPrivilegeIds]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/11/11 15:54
     */
    List<Integer> getNewPrivilegeIds(List<Integer> oldPrivilegeIds);

    /** 
     * @description: 获取模块
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/10/26 10:23
     */
    ModulesVo getModules(Integer userId, Integer groupId);

    /**
     * @description: 获取权限 APP
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/10/27 16:59
     */
    List<PrivilegesVo> getPrivileges(Integer userId, Integer groupId);

    /** 
     * @description: 首页-获取用户常用模块-APP
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.PrivilegesVo>
     * @author wxb
     * @date: 2020/11/3 23:01
     */ 
    List<PrivilegesVo> getUserRecentModules(Integer userId, Integer groupId);

    /**
     * @description: 首页-保存用户常用的模块-APP
     * @param: [userId, moduleIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/3 23:46
     */
    Boolean saveUserRecentModules(Integer userId, String moduleIds);

    /**
     * @description: 管理-获取用户订阅模块-APP
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.PrivilegesVo>
     * @author wxb
     * @date: 2020/11/3 23:01
     */
    List<PrivilegesPojo> getUserSubscribeModules(Integer userId, Integer groupId);

    /** 
     * @description: 管理-保存用户订阅模块-APP
     * @param: [userId, moduleIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/6 17:03
     */ 
    Boolean saveUserSubscribeModules(Integer userId, String moduleIds);

    /** 
     * @description: 用户是否有某个权限
     * @param: [userId, privilegeId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/13 13:58
     */ 
    Boolean isUserPrivilegeByUserIdAndPrivilegeId(Integer userId, Integer privilegeId);

    /** 
     * @description: 用户是否有某个权限
     * @param: [userId, privilegeName]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/13 14:03
     */
    Boolean isUserPrivilegeByUserIdAndPrivilegeName(Integer userId, String privilegeName);

    /**
     * @description: 获取用户的指定权限
     * @param: [userId, privilegeId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/14 13:44
     */
    PrivilegesPojo getPrivilegeByUserIdAndPrivilegeId(Integer userId, Integer privilegeId);
    
    /** 
     * @description: 获取用户的权限菜单
     * @param: [user]
     * @return: java.util.List<com.ovopark.privilege.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/11/14 13:49
     */ 
    List<PrivilegesVo> getUserPrivileges(UsersPojo user);

    /** 
     * @description: 新增用户权限
     * @param: [userPrivilege]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/14 13:50
     */ 
    Boolean insterUserPrivileges(UserPrivilegesPojo userPrivilege);

    /**
     * @description: 批量新增用户权限
     * @param: [userPrivilege]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/14 13:50
     */
    Boolean batchInsterUserPrivileges(List<UserPrivilegesPojo> userPrivileges);

    /** 
     * @description: 删除用户的所有权限
     * @param: [userId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/14 13:51
     */ 
    Boolean deleteUserPrivilegesByUserId(Integer userId);

    /** 
     * @description: 删除用户的指定权限
     * @param: [userId, privilegeId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/14 13:53
     */ 
    Boolean deleteUserPrivilegesByUserIdAndPrivilegeId(Integer userId, Integer privilegeId);

    /** 
     * @description: 更新用户权限
     * @param: [userPrivilege]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/14 13:53
     */ 
    Boolean updateUserPrivileges(UserPrivilegesPojo userPrivilege);

    /** 
     * @description: 根据企业id获取权限列表
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.model.pojo.PrivilegesPojo>
     * @author wxb
     * @date: 2020/11/14 14:05
     */ 
    List<PrivilegesPojo> getPrivilegesByGroupId(Integer groupId);

}
