package com.ovopark.privilege.service;

import com.ovopark.privilege.model.entity.ProjectPrivileges;

import java.util.List;

/**
 * @description: 方案权限表
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/10/13 15:35
 */
public interface ProjectPrivilegesService {

    /**
     * @description: 新增方案权限表
     * @param: [projectPrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 15:37
     */
    void insertProjectPrivileges(ProjectPrivileges projectPrivileges);

    /**
     * @description: 更新方案权限
     * @param: [projectPrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 15:37
     */
    void updateProjectPrivileges(ProjectPrivileges projectPrivileges);
    
    /** 
     * @description: 根据方案id删除方案权限表
     * @param: [projectId]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 16:13
     */ 
    void deleteProjectPrivilegesByProjectId(Integer projectId);

    /**
     * @description: 获取方案权限
     * @param: [planId]
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.MenusPrivilegesVo>
     * @author wxb
     * @date: 2020/10/13 19:49
     */
    List<ProjectPrivileges> getPlanPrivileges(Integer projectId);
}
