package com.ovopark.privilege.service;

import com.ovopark.privilege.model.entity.Projects;
import com.ovopark.privilege.model.vo.ProjectVo;

import java.util.List;

/** 
 * @description: 方案
 * @param: 
 * @return: 
 * @author wxb
 * @date: 2020/10/13 15:17
 */
public interface ProjectsService {

    /**
     * @description:
     * @param: [id]
     * @return: com.ovopark.privilege.server.model.entity.Projects
     * @author wxb
     * @date: 2020/10/13 15:51
     */
    Projects getProjectById(Integer id);

    /**
     * @description: 新增方案
     * @param: [projects]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 15:37
     */
    Projects insertProject(Projects projects);

    /**
     * @description: 更新方案
     * @param: [projects]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 15:37
     */
    void updateProject(Projects projects);

    /**
     * @description: 保存方案
     * @param: [userId, planName, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/20 14:46
     */
    Boolean saveProject(Integer userId, String planName, String privilegeIds);

    /**
     * @description: 覆盖方案
     * @param: [userId, planId, planName, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/20 14:46
     */
    Boolean updateProject(Integer userId, Integer planId, String planName, String privilegeIds);

    /** 
     * @description: 获取方案
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.vo.ProjectVo>
     * @author wxb
     * @date: 2020/10/13 18:59
     */ 
    List<ProjectVo> getPlans();
    
    /** 
     * @description: 根据id删除方案
     * @param: [planId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/20 15:54
     */ 
    void deletePlanById(Integer planId);
    
    /** 
     * @description: 删除方案
     * @param: [planId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/21 13:10
     */ 
    Boolean deletePlan(Integer planId);

}
