package com.ovopark.privilege.service;


import com.ovopark.privilege.model.entity.RolePrivileges;

import java.util.List;

/**
 * @description: 角色权限接口
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/9/21 15:45
 */
public interface RolePrivilegesService {

    /** 
     * @description: 根据角色id获取角色权限
     * @param: [roleId]
     * @return: com.ovopark.privilege.server.model.entity.RolePrivileges
     * @author wxb
     * @date: 2020/9/22 9:58
     */ 
    List<RolePrivileges> getRolePrivilegesByRoleId(Integer roleId);

    /** 
     * @description: 获取权限id根据角色id
     * @param: [roleId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 9:19
     */ 
    List<Integer> getPrivilegeIdsByRoleId(Integer roleId);

    /** 
     * @description: 删除角色权限
     * @param: [roleId, privileges]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 9:29
     */ 
    void batchDeleteRolePrivilegesByPrivilegeIds(Integer roleId, List<Integer> privilegeIds);
    
    /** 
     * @description: 新增角色权限
     * @param: [rolePrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 9:59
     */ 
    void insterRolePrivileges(RolePrivileges rolePrivileges);

    /** 
     * @description: 获取角色的权限id
     * @param: [roleIds]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 14:06
     */ 
    List<Integer> getPrivilegeIdsByRoles(List<Integer> roleIds);

    /** 
     * @description: 删除角色权限
     * @param: [roleId]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 14:49
     */ 
    void deleteRolePrivilegesByRoleId(Integer roleId);

}
