package com.ovopark.privilege.service;


import com.ovopark.privilege.model.entity.Roles;
import com.ovopark.privilege.model.entity.Users;
import com.ovopark.privilege.model.mo.RoleMo;
import com.ovopark.privilege.model.pojo.RolesPojo;

import java.util.List;

/**
 * @description: 角色接口
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/9/21 15:45
 */
public interface RolesService {

    /**
     * @description: 获取角色根据ID
     * @param: [id]
     * @return: com.ovopark.privilege.server.model.entity.Roles
     * @author wxb
     * @date: 2020/10/28 13:11
     */
    Roles getById(Integer id);

    /**
     * @description: 根据id获取角色
     * @param: [id]
     * @return: com.ovopark.privilege.server.model.pojo.RolesPojo
     * @author wxb
     * @date: 2020/9/22 9:33
     */
    RolesPojo getRoleById(Integer id);

    /** 
     * @description: 删除角色
     * @param: [roles]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 14:53
     */ 
    void deleteById(Roles roles);

    /**
     * @description: 根据groupId获取角色列表
     * @param: [groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Role>
     * @author wxb
     * @date: 2020/9/21 15:48
     */
    List<RolesPojo> getRoleListByGroupId(Integer groupId);

    /**
     * @description: 获取用户角色列表
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>
     * @author wxb
     * @date: 2020/9/22 9:30
     */
    List<RolesPojo> getRoleListByUser(Integer userId, Integer groupId);

    /**
     * @description: 角色列表--角色管理页面
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Role>
     * @author wxb
     * @date: 2020/9/21 16:05
     */
    List<RolesPojo> getRoleList(Integer userId, Integer groupId);

    /** 
     * @description: 通过企业id获取对应的角色列表--用户管理页面
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>
     * @author wxb
     * @date: 2020/9/24 13:13
     */ 
    List<RolesPojo> getRoleListByGroup(Integer userId, Integer groupId);

    /** 
     * @description: 获取企业角色列表
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>
     * @author wxb
     * @date: 2020/9/24 13:15
     */ 
    List<RolesPojo> getRoleListByUserAndGroupId(Users user, Integer groupId);

    /**
     * @description: 根据ID列表获取角色列表
     * @param: [roleIds]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>
     * @author wxb
     * @date: 2020/9/24 13:47
     */
    List<RolesPojo> getRoleListByIds(List<Integer> roleIds);

    /** 
     * @description: 根据用户id和企业id获取角色列表
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>
     * @author wxb
     * @date: 2020/9/24 13:49
     */ 
    List<RolesPojo> getRoleListByUserIdAndGroupId(Integer userId, Integer groupId);

    /**
     * @description: 根据id更新权限
     * @param: [rolesPojo]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 14:01
     */
    void updateRolesById (RolesPojo rolesPojo);

    /** 
     * @description: 根据角色名和企业id获取角色列表
     * @param: [roleName, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.pojo.RolesPojo>
     * @author wxb
     * @date: 2020/10/28 9:29
     */ 
    List<RolesPojo> getRoleListByRoleNameAndGroupId(String roleName, Integer groupId);

    /**
     * @description: 获取角色id根据角色名称和企业id
     * @param: [roleName, groupId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 10:48
     */
    List<Integer> getRoleIdsByRoleNameAndGroupId(String roleName, Integer groupId);
    
    /** 
     * @description: 新增角色并返回
     * @param: [roles]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 9:32
     */
    Roles saveRolesAndBack(Roles roles);

    /** 
     * @description: 保存角色
     * @param: [role, privilegeIds]
     * @return: com.ovopark.privilege.server.model.pojo.RolesPojo
     * @author wxb
     * @date: 2020/10/28 9:36
     */ 
    Roles saveRolesAndRolePrivileges(Roles roles,List<Integer> privilegeIds);

    /**
     * @description: 更新角色
     * @param: [roleName, groupId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/28 10:50
     */
    Boolean updateRole(Integer userId, RoleMo role, List<Integer> privilegeIds);

    /** 
     * @description: 同步更新角色
     * @param: [userId, role, privilegeIds]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/11 15:08
     */ 
    Boolean synUpdateRole(Integer userId, RoleMo role, List<Integer> privilegeIds);

    /**
     * @description: 更新角色并返回
     * @param: [role, privilegeIds]
     * @return: com.ovopark.privilege.server.model.entity.Roles
     * @author wxb
     * @date: 2020/10/28 10:59
     */
    Roles updateRoleAndPrivilege(Integer userId, RoleMo role, List<Integer> privilegeIds);

    /** 
     * @description: 删除角色
     * @param: [roleId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/28 14:36
     */ 
    Boolean deleteRole(Integer userId, Integer roleId);
}
