package com.ovopark.privilege.service;

import com.ovopark.privilege.model.entity.SignUsers;

/**
 * <p>
 * 用户中间表 服务类
 * </p>
 *
 * @author wxb
 * @since 2020-09-10
 */
public interface SignUsersService {

    /**
     * @description: 根据用户名和企业ID获取用户
     * @param: [userName, groupId]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:06
     */
    SignUsers getSignUserByUserNameAndGroupId(String userName, Integer groupId);

    /**
     * @description: 根据用户名获取用户
     * @param: [userName]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:06
     */
    SignUsers getSignUserByUserName(String userName);

    /**
     * @description: 根据邮箱获取用户
     * @param: [email]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:07
     */
    SignUsers getSignUserByEmail(String email);

    /**
     * @description: 根据手机号获取用户
     * @param: [phone]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:07
     */
    SignUsers getSignUserByPhone(String phone);
}
