package com.ovopark.privilege.service;

import com.ovopark.privilege.model.entity.UserDepartment;

import java.util.List;

/**
 * @description: 门店角色人员表
 * @param: 
 * @return: 
 * @author wxb
 * @date: 2020/10/14 13:56
 */ 
public interface UserDepartmentService {

    /** 
     * @description: 根据用户id和企业id获取门店角色人员
     * @param: [userId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserDepartment>
     * @author wxb
     * @date: 2020/10/14 13:58
     */ 
    List<UserDepartment> getUserDepartmentsByUser(Integer userId, Integer groupId);

    /** 
     * @description: 根据用户的权限获取门店角色人员
     * @param: [userId, roleId, groupId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserDepartment>
     * @author wxb
     * @date: 2020/10/23 13:41
     */ 
    List<UserDepartment> getUserDepartmentsByUserAndRoleId(Integer userId, Integer groupId,Integer roleId);

    /** 
     * @description: 删除用户、角色 关联的门店
     * @param: [userId, roleId, groupId]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 13:26
     */ 
    void deleteByUserAndRoleId(Integer userId, Integer groupId, Integer roleId);

    /** 
     * @description: 删除用户、角色 关联的门店
     * @param: [depId, roleId]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 15:36
     */ 
    void deleteByDepId(Integer depId,Integer roleId);

    /** 
     * @description: 保存用户门店角色
     * @param: [userDepartment]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 14:47
     */ 
    void insertUserDepartment(UserDepartment userDepartment);

    /** 
     * @description: 保存用户角色关系
     * @param: [userId, groupId, roleId, deptList]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 15:21
     */ 
    void saveUserDepartment(Integer userId, Integer groupId, Integer roleId, List<Integer> deptList);

}
