package com.ovopark.privilege.service;


import com.ovopark.privilege.model.entity.UserPrivileges;

import java.util.List;

/**
 * <p>
 * 用户权限信息表 服务类
 * </p>
 *
 * @author wxb
 * @since 2020-09-01
 */
public interface UserPrivilegesService {

    /**
     * @description: 删除用户权限
     * @param: [userId]
     * @return: void
     * @author wxb
     * @date: 2020/9/24 14:52
     */ 
    void deleteUserPrivileges(Integer userId, Integer groupId);
    
    /** 
     * @description: 保存用户权限
     * @param: [userPrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/9/24 15:15
     */ 
    void saveUserPrivileges(UserPrivileges userPrivileges);

    /**
     * @description: 获取用户的所有权限id
     * @param: [userId, groupId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 13:42
     */
    List<Integer> getPrvilegeIdsByUser(Integer userId, Integer groupId);

    /** 
     * @description: 批量删除用户的权限
     * @param: [userId, groupId, privilegeIds]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 14:15
     */ 
    void batchDeleteUserPrivileges(Integer userId, Integer groupId, List<Integer> privilegeIds);

    /** 
     * @description: 获取用户权限 权限id
     * @param: [userId, privilegeId]
     * @return: com.ovopark.privilege.server.model.entity.UserPrivileges
     * @author wxb
     * @date: 2020/11/10 20:03
     */ 
    UserPrivileges getUserPrivilegesByUserIdAndPrivilegeId(Integer userId, Integer privilegeId);

    /**
     * @description: 获取用户权限 权限名称
     * @param: [userId, privilegeName]
     * @return: com.ovopark.privilege.server.model.entity.UserPrivileges
     * @author wxb
     * @date: 2020/11/13 14:03
     */
    UserPrivileges getUserPrivilegesByUserIdAndPrivilegeName(Integer userId, String privilegeName);

    /**
     * @description:
     * @param: [userPrivileges]
     * @return: com.ovopark.privilege.model.entity.UserPrivileges
     * @author wxb
     * @date: 2020/11/14 14:07
     */
    void insterUserPrivileges(UserPrivileges userPrivileges);

    /**
     * @description: 删除用户的所有权限
     * @param: [userId]
     * @return: void
     * @author wxb
     * @date: 2020/11/17 19:30
     */
    Boolean deleteUserPrivilegesByUserId(Integer userId);

    /**
     * @description: 删除用户的指定权限
     * @param: [userId, privilegeId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/17 19:31
     */
    Boolean deleteUserPrivilegesByUserIdAndPrivilegeId(Integer userId, Integer privilegeId);

    /**
     * @description: 更新用户权限
     * @param: [userPrivilege]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/11/17 19:31
     */
    Boolean updateUserPrivileges(UserPrivileges userPrivileges);

}
