package com.ovopark.privilege.service;

import com.ovopark.privilege.model.entity.UserRecentModule;
import com.ovopark.privilege.model.pojo.PrivilegesPojo;

import java.util.List;

/**
 * @description: 用户常用模块
 * @param: 
 * @return: 
 * @author wxb
 * @date: 2020/9/224:06
 */ 
public interface UserRecentModuleService {

    /** 
     * @description: 获取用户常用模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentModule>
     * @author wxb
     * @date: 2020/11/3 23:21
     */ 
    List<PrivilegesPojo> getUserRecentModulePrivileges(Integer userId);

    /** 
     * @description: 获取用户常用模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentModule>
     * @author wxb
     * @date: 2020/11/4 0:11
     */ 
    List<UserRecentModule> getUserRecentModules(Integer userId);

    /** 
     * @description: 更新用户常用模块
     * @param: [userRecentModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:01
     */ 
    void updateUserRecentModule(UserRecentModule userRecentModule);

    /**
     * @description: 删除用户常用模块
     * @param: [userRecentProduct]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:03
     */
    void deleteUserRecentModule(UserRecentModule userRecentModule);
    
    /** 
     * @description: 新增常用模块
     * @param: [userRecentModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/5 13:10
     */ 
    void insterUserRecentModule(UserRecentModule userRecentModule);
    

}
