package com.ovopark.privilege.service;


import com.ovopark.privilege.model.entity.UserRecentProduct;

import java.util.List;

/**
 * @description: 用户订阅产品
 * @param: 
 * @return: 
 * @author wxb
 * @date: 2020/9/224:06
 */ 
public interface UserRecentProductService {

    /**
     * @description: 获取订阅模块 根据id
     * @param: [id]
     * @return: com.ovopark.privilege.server.model.entity.UserRecentProduct
     * @author wxb
     * @date: 2020/10/29 11:08
     */
    UserRecentProduct getUserRecentProductById(Integer id);

    /**
     * @description: 获取用户订阅产品
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentProduct>
     * @author wxb
     * @date: 2020/10/29 10:23
     */
    List<UserRecentProduct> getUserRecentProductList(Integer userId);

    /**
     * @description: 更新用户订阅产品
     * @param: [userRecentProduct]
     * @return: void
     * @author wxb
     * @date: 2020/10/29 10:25
     */
    void updateUserRecentProduct(UserRecentProduct userRecentProduct);

    /** 
     * @description: 删除订阅的产品
     * @param: [userRecentProduct]
     * @return: void
     * @author wxb
     * @date: 2020/10/29 17:06
     */ 
    void deleteUserRecentProduct(UserRecentProduct userRecentProduct);

    /** 
     * @description: 保存订阅的产品
     * @param: [userRecentProduct]
     * @return: void
     * @author wxb
     * @date: 2020/11/7 17:19
     */ 
    void insterUserRecentProduct(UserRecentProduct userRecentProduct);

}
