package com.ovopark.privilege.service;

import com.ovopark.privilege.model.entity.UserRole;

import java.util.List;

/**
 * @description: 用户角色
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/9/22 14:06
 */
public interface UserRoleService {

    /**
     * @description: 是否是超级管理员
     * @param: [userId, groupId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/9/17 15:07
     */
    Boolean isSuperAdmin(Integer userId, Integer groupId);

    /** 
     * @description: 是否是系统管理员
     * @param: [userId, groupId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/9/21 16:20
     */ 
    Boolean isSystemAdmin(Integer userId, Integer groupId);

    /**
     * @description: 根据用户ID和企业ID获取角色ID
     * @param: [userId, groupId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/9/17 15:07
     */
    List<Integer> getRoleIdsByUserIdAndGroupId(Integer userId, Integer groupId);

    /** 
     * @description: 
     * @param: [roleId]
     * @return: java.lang.Integer
     * @author wxb
     * @date: 2020/9/22 9:44
     */ 
    Integer getCountByRoleId(Integer roleId);

    /** 
     * @description:
     * @param: [roleId, groupId]
     * @return: java.lang.Integer
     * @author wxb
     * @date: 2020/9/22 9:47
     */ 
    Integer getCountByRoleIdAndGroupId(Integer roleId, Integer groupId);
    
    /** 
     * @description: 查询用户设置的角色
     * @param: [userId, groupId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/23 13:23
     */ 
    List<Integer> getRoleIdsByUser(Integer userId, Integer groupId);

    /** 
     * @description: 删除用户的角色
     * @param: [userId, groupId]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 13:46
     */ 
    void deleteUserRolesByUser(Integer userId, Integer groupId);

    /**
     * @description: 删除用户的角色
     * @param: [userId, groupId]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 13:46
     */
    void deleteUserRolesByRole(Integer roleId, Integer groupId);
    
    /** 
     * @description: 保存用户角色
     * @param: [userRole]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 14:15
     */ 
    void insterUserRoles(UserRole userRole);

    /** 
     * @description: 保存用户角色关系
     * @param: [roleIds, userId, groupId]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 15:14
     */ 
    void saveUserRoles(List<Integer> roleIds, Integer userId, Integer groupId);

    /**
     * @description: 获取拥有该角色的所有用户id
     * @param: [roleId, groupId, isSystemAdmin]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 10:00
     */
    List<Integer> getUserIdsByRole(Integer userId, Integer groupId, Integer roleId, boolean isSystemAdmin);

    /**
     * @description: 获取用户的角色
     * @param: []
     * @return: com.ovopark.privilege.server.model.entity.UserRole
     * @author wxb
     * @date: 2020/11/12 15:06
     */
    UserRole getUserRoleByUserIdAndGroupId(Integer userId, Integer groupId);

}
