package com.ovopark.privilege.service;

import com.ovopark.privilege.model.entity.UserSubscribeModule;
import com.ovopark.privilege.model.pojo.PrivilegesPojo;

import java.util.List;

/**
 * @description: 用户订阅模块
 * @param: 
 * @return: 
 * @author wxb
 * @date: 2020/9/224:06
 */ 
public interface UserSubscribeModuleService {

    /** 
     * @description: 获取用户订阅模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentModule>
     * @author wxb
     * @date: 2020/11/3 23:21
     */ 
    List<PrivilegesPojo> getUserSubscribeModulePrivileges(Integer userId);

    /** 
     * @description: 获取用户订阅模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentModule>
     * @author wxb
     * @date: 2020/11/4 0:11
     */ 
    List<UserSubscribeModule> getUserSubscribeModules(Integer userId);

    /** 
     * @description: 更新用户订阅模块
     * @param: [UserSubscribeModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:01
     */ 
    void updateUserSubscribeModule(UserSubscribeModule userSubscribeModule);

    /**
     * @description: 删除用户订阅模块
     * @param: [UserSubscribeModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:03
     */
    void deleteUserSubscribeModule(UserSubscribeModule userSubscribeModule);
    
    /** 
     * @description: 新增订阅模块
     * @param: [UserSubscribeModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/5 13:10
     */ 
    void insterUserSubscribeModule(UserSubscribeModule userSubscribeModule);
    

}
