package com.ovopark.privilege.service;


import com.ovopark.privilege.common.response.CommonPage;
import com.ovopark.privilege.model.entity.Users;

import java.util.List;

/**
 * <p>
 * 用户信息表 服务类
 * </p>
 *
 * @author wxb
 * @since 2020-09-10
 */
public interface UsersService {

    /**
     * @description: 根据用户名和企业ID获取用户
     * @param: [userName, groupId]
     * @return: com.ovopark.privilege.server.model.entity.Users
     * @author wxb
     * @date: 2020/9/17 15:07
     */
    Users getUserByUserNameAndGroupId(String userName, Integer groupId);

    /**
     * @description: 根据用户名查询用户
     * @param: [userName]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Users>
     * @author wxb
     * @date: 2020/9/17 15:07
     */
    List<Users> getUserByUserName(String userName);

    /**
     * @description: 根据邮箱查询用户
     * @param: [email]
     * @return: com.ovopark.privilege.server.model.entity.Users
     * @author wxb
     * @date: 2020/9/17 15:07
     */
    Users getUserByUserEmail(String email);

    /**
     * @description: 根据手机号查询用户
     * @param: [phone]
     * @return: com.ovopark.privilege.server.model.entity.Users
     * @author wxb
     * @date: 2020/9/17 15:08
     */
    Users getUserByUserPhone(String phone);

    /**
     * @description: 根据id获取用户
     * @param: [id]
     * @return: com.ovopark.privilege.server.model.entity.Users
     * @author wxb
     * @date: 2020/9/17 15:08
     */
    Users getUserById(Integer id);

    /**
     * @description: 更新用户
     * @param: [users]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 15:38
     */
    void updateUserById(Users users);

    /**
     * @description: 新增用户
     * @param: [users]
     * @return: void
     * @author wxb
     * @date: 2020/10/23 15:39
     */
    void insterUser(Users users);

    /** 
     * @description: 获取拥有该角色的所有用户
     * @param: [userName, roleId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Users>
     * @author wxb
     * @date: 2020/10/28 9:54
     */ 
    List<Users> getUsersByRole(Integer userId, String userName, Integer roleId);

    /** 
     * @description: 分页查询用户
     * @param: [userName, userIds, pageNum, pageSize]
     * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.ovopark.privilege.server.model.entity.Users>
     * @author wxb
     * @date: 2020/10/28 10:18
     */
    CommonPage<Users> getUsersByUserNameAndUserIdsAsPage(String userName, List<Integer> userIds, Integer pageNum, Integer pageSize);

    /** 
     * @description: 查询用户
     * @param: [userName, userIds]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Users>
     * @author wxb
     * @date: 2020/10/28 10:41
     */ 
    List<Users> getUsersByUserNameAndUserIds(String userName, List<Integer> userIds);
    
    /** 
     * @description: 删除用户
     * @param: [userId, groupId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/28 15:57
     */ 
    Boolean deleteUser(Integer userId, Integer groupId, String token);

    /** 
     * @description: 冻结用户
     * @param: [userId, groupId, token]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/28 17:21
     */ 
    Boolean userFreeze(Integer userId, Integer groupId, String token);

    /** 
     * @description: 解冻用户
     * @param: [userId, groupId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/28 17:26
     */ 
    Boolean userUnfreeze(Integer userId, Integer groupId);

    /**
     * @description: 删除用户
     * @param: [userId, groupId]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/28 15:57
     */
    Boolean deleteBatchUser(String userIds, Integer groupId, String token);

    /**
     * @description: 冻结用户
     * @param: [userId, groupId, token]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/10/28 17:21
     */
    Boolean userBatchFreeze(String userId, Integer groupId, String token);
    
}
