package com.ovopark.privilege.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "websocket" , url = "${websocketUrl}")
public interface WebSocketService {
	
	/***
	 * 广播
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/broadcast")
	Object broadcast(@RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/***
	 * 给某个门店发消息
	 * @param depId
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToDepId")
	void sendMessageToDepId(@RequestParam("depId") Integer depId, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/***
	 * 给某个门店发消息
	 * @param depId
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendAllMessageToDepId")
	Object sendAllMessageToDepId(@RequestParam("depId") Integer depId, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/**
	 * 给某个sessionId发消息
	 * @param sessionId
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToSessionId")
	Object sendMessageToSessionId(@RequestParam("sessionId") String sessionId, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/**
	 * 给某个sessionId发消息
	 * @param uuid
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToUuid")
	Object sendMessageToUuid(@RequestParam("uuid") String uuid, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/**
	 * 给某个设备发消息
	 * @param deviceId
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToDeviceId")
	Object sendMessageToDeviceId(@RequestParam("deviceId") Integer deviceId, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/**
	 * 给某个user发消息
	 * @param userId
	 * @param clients
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToUser")
	Object sendMessageToUser(@RequestParam("userId") Integer userId, @RequestParam("clients") String clients, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/**
	 * 消息删除
	 * @param userId
	 * @param message
	 * @return
	 */
	@RequestMapping("/websocket/sendRemoveMessage")
	Object sendRemoveMessage(@RequestParam("userId") Integer userId, @RequestParam("message") String message);
	
	/**
	 * 安卓大屏推送
	 * @param macs
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToBigAndroidMacs")
	Object sendMessageToBigAndroidMacs(@RequestParam("macs") String macs, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	
	/**
	 * OVOSTATION推送
	 * @param license
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToOvostation")
	Object sendMessageToOvostation(@RequestParam("license") String license, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	
	/**
	 * 获取OVOSTATION在线状态
	 * @param licenses
	 * @return
	 */
	@RequestMapping("/websocket/checkOvostationOnlineStatus")
	Object checkOvostationOnlineStatus(@RequestParam("licenses") String licenses);
	/**
	 * 通过websocket发送文件上传完成，可以播放的消息
	 * @param sessionId
	 * @param mac
	 * @param taskId
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendRecPlaySession")
	Object sendRecPlaySession(@RequestParam("sessionId") String sessionId, @RequestParam("mac") String mac, @RequestParam("taskId") String taskId, @RequestParam("message") String message, @RequestParam("messageType") String messageType);
	/**
	 * 通过websocket发送文件上传完成，可以下载的消息
	 * @param sessionId
	 * @param mac
	 * @param taskId
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendRecDownloadSession")
	Object sendRecDownloadSession(@RequestParam("sessionId") String sessionId, @RequestParam("mac") String mac, @RequestParam("taskId") String taskId, @RequestParam("message") String message, @RequestParam("messageType") String messageType);

	/**
	 * 信发设备推送
	 * @param macs
	 * @param message
	 * @param messageType
	 * @return
	 */
	@RequestMapping("/websocket/sendMessageToAndroidBox")
	Object sendMessageToXinfaMacs(@RequestParam("mac") String macs, @RequestParam("message") String message, @RequestParam("messageType") String messageType);

}
