package com.ovopark.privilege.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.api.DepartmentApi;
import com.ovopark.pojo.BaseResult;
import com.ovopark.pojo.DepartmentPojo;
import com.ovopark.privilege.service.DepartmentService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wxb
 * @Title: DepartmentServiceImpl
 * @Description: 门店接口
 * @date 2020/10/14 14:12
 **/
@Service
@Slf4j
public class DepartmentServiceImpl implements DepartmentService {

    @Resource
    private DepartmentApi departmentApi;

    /**
     * @description: 根据id获取门店map  Map<门店ID，门店名称>
     * @param: [depIdList]
     * @return: java.util.Map<java.lang.Integer,java.lang.String>
     * @author wxb
     * @date: 2020/11/12 13:45
     */
    @Override
    public Map<Integer, String> getDepMapByIds(List<Integer> depIdList) {
        Map<Integer, String> depMap = new HashMap<>();
        // 获取门店
        List<DepartmentPojo> departmentPojoList = new ArrayList<>();
        BaseResult<List<DepartmentPojo>> departmentById = this.departmentApi.getDepartmentListByIdList(depIdList);
        if (!departmentById.getIsError()) {
            departmentPojoList = departmentById.getData();
            if (CollectionUtils.isNotEmpty(departmentPojoList)){
                for (DepartmentPojo departmentPojo : departmentPojoList){
                    depMap.put(departmentPojo.getId(),departmentPojo.getName());
                }
            }
            return depMap;
        }
        return null;
    }
}
