package com.ovopark.privilege.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.common.utils.CollectionUtil;
import com.ovopark.privilege.mapper.EnterprisePrivilegesMapper;
import com.ovopark.privilege.model.entity.EnterprisePrivileges;
import com.ovopark.privilege.service.EnterprisePrivilegesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 权限表 服务实现类
 * </p>
 *
 * @author wxb
 * @since 2020-09-01
 */
@Slf4j
@Service
public class EnterprisePrivilegesServiceImpl extends ServiceImpl<EnterprisePrivilegesMapper, EnterprisePrivileges> implements EnterprisePrivilegesService {

    /**
     * @description: 删除企业权限 根据企业id
     * @param: [enterpriseId]
     * @return: void
     * @author wxb
     * @date: 2020/9/17 15:08
     */
    @Override
    public void deleteEnterprisePrivileges(Integer enterpriseId) {
        if (enterpriseId != null){
            LambdaQueryWrapper<EnterprisePrivileges> queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(EnterprisePrivileges::getEnterpriseId,enterpriseId);
            this.baseMapper.delete(queryWrapper);
        }
    }

    /**
     * @description: 添加企业权限
     * @param: [enterprisePrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/9/17 15:09
     */
    @Override
    public void insertEnterprisePrivileges(EnterprisePrivileges enterprisePrivileges) {
        if (enterprisePrivileges != null){
            this.baseMapper.insert(enterprisePrivileges);
        }
    }

    /**
     * @description: 批量保存企业权限
     * @param: [enterprisePrivilegesList]
     * @return: java.lang.Boolean
     * @author wxb
     * @date: 2020/9/17 15:09
     */
    @Override
    public Boolean batchInsertEnterprisePrivileges(List<EnterprisePrivileges> enterprisePrivilegesList) {
        if (CollectionUtils.isNotEmpty(enterprisePrivilegesList)){
            for (EnterprisePrivileges enterprisePrivileges : enterprisePrivilegesList){
                // 查询企业权限
                EnterprisePrivileges enterprisePrivilege = this.getEnterprisePrivilegesByEnterpriseIdAndPrivilegeId(enterprisePrivileges.getEnterpriseId(),enterprisePrivileges.getPrivilegeId());
                // 不存在
                if (enterprisePrivilege == null){
                    // 新增
                    this.baseMapper.insert(enterprisePrivileges);
                }
            }
            return true;
        }
        return false;
    }

    /**
     * @description: 获取企业权限
     * @param: [enterpriseId, privilegeId]
     * @return: com.ovopark.privilege.server.model.entity.EnterprisePrivileges
     * @author wxb
     * @date: 2020/9/17 15:09
     */
    @Override
    public EnterprisePrivileges getEnterprisePrivilegesByEnterpriseIdAndPrivilegeId(Integer enterpriseId, Integer privilegeId) {
        LambdaQueryWrapper<EnterprisePrivileges> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EnterprisePrivileges::getEnterpriseId,enterpriseId).eq(EnterprisePrivileges::getPrivilegeId,privilegeId);
        return this.baseMapper.selectOne(queryWrapper);
    }

    /** 
     * @description: 根据企业id获取权限id列表
     * @param: [enterpriseId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/9/24 14:59
     */ 
    @Override
    public List<Integer> getPrivilegeIdsByEnterpriseId(Integer enterpriseId) {
        List<Integer> privilegeIds = new ArrayList<>();
        List<EnterprisePrivileges> enterprisePrivileges = new ArrayList<>();
        LambdaQueryWrapper<EnterprisePrivileges> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EnterprisePrivileges::getEnterpriseId,enterpriseId);
        enterprisePrivileges = this.baseMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(enterprisePrivileges)){
            for (EnterprisePrivileges enterprisePrivilege : enterprisePrivileges){
                if (enterprisePrivilege != null){
                    privilegeIds.add(enterprisePrivilege.getPrivilegeId());
                }
            }
        }
        return privilegeIds;
    }

    /**
     * @description: 批量查询企业权限
     * @param: [privilegeIdList]
     * @return: java.util.List<com.ovopark.privilege.model.entity.EnterprisePrivileges>
     * @author wxb
     * @date: 2020/11/24 20:14
     */
    @Override
    public List<EnterprisePrivileges> getEnterprisePrivilegesByPrivilegeIds(List<Integer> privilegeIdList) {
        if (CollectionUtil.isNotEmpty(privilegeIdList)){
            LambdaQueryWrapper<EnterprisePrivileges> queryWrapper = new LambdaQueryWrapper<EnterprisePrivileges>();
            queryWrapper.in(EnterprisePrivileges::getPrivilegeId,privilegeIdList);
            return this.baseMapper.selectList(queryWrapper);
        }
        return null;
    }

    /**
     * @description: 批量删除企业权限
     * @param: [enterprisePrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/11/24 20:15
     */
    @Override
    public void batchDeleteEnterprisePrivileges(List<EnterprisePrivileges> enterprisePrivileges) {
        if (CollectionUtil.isNotEmpty(enterprisePrivileges)){
            for (EnterprisePrivileges enterprisePrivilege : enterprisePrivileges){
                this.baseMapper.deleteById(enterprisePrivilege.getId());
            }
        }
    }

    /**
     * @description: 获取企业的权限
     * @param: [enterpriseId]
     * @return: java.util.List<com.ovopark.privilege.model.entity.EnterprisePrivileges>
     * @author wxb
     * @date: 2020/11/24 20:28
     */
    @Override
    public List<EnterprisePrivileges> getEnterprisePrivilegesByEnterpriseId(Integer enterpriseId) {
        if (enterpriseId != null){
            LambdaQueryWrapper<EnterprisePrivileges> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(EnterprisePrivileges::getEnterpriseId,enterpriseId);
            return this.baseMapper.selectList(queryWrapper);
        }
        return null;
    }
}
