package com.ovopark.privilege.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.common.utils.CollectionUtil;
import com.ovopark.privilege.mapper.OldPrivilegesMapper;
import com.ovopark.privilege.model.entity.OldPrivileges;
import com.ovopark.privilege.service.OldPrivilegesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 权限表 服务实现类
 * </p>
 *
 * @author wxb
 * @since 2020-09-01
 */
@Slf4j
@Service
public class OldPrivilegesServiceImpl extends ServiceImpl<OldPrivilegesMapper, OldPrivileges> implements OldPrivilegesService {

    /**
     * @description: 批量获取权限
     * @param: [privilegeIdList]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Privilege>
     * @author wxb
     * @date: 2020/11/10 17:30
     */
    @Override
    public List<OldPrivileges> getOldPrivilegeListByIds(List<Integer> privilegeIdList) {
        if (CollectionUtil.isNotEmpty(privilegeIdList)){
            LambdaQueryWrapper<OldPrivileges> queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(OldPrivileges::getId,privilegeIdList);
            return this.baseMapper.selectList(queryWrapper);
        }
        return null;
    }

    /**
     * @description: 根据id获取权限
     * @param: [privilegeId]
     * @return: com.ovopark.privilege.server.model.entity.Privilege
     * @author wxb
     * @date: 2020/11/10 20:21
     */
    @Override
    public OldPrivileges getOldPrivilegesById(Integer privilegeId) {
        if (privilegeId != null){
            return this.baseMapper.selectById(privilegeId);
        }
        return null;
    }
}
