package com.ovopark.privilege.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.ProductMapper;
import com.ovopark.privilege.model.entity.Product;
import com.ovopark.privilege.model.pojo.ProductPojo;
import com.ovopark.privilege.service.ProductService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 产品
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/9/22 14:07
 */
@Service
public class ProductServiceImpl extends ServiceImpl<ProductMapper, Product> implements ProductService {

    /**
     * @description: 根据id获取产品
     * @param: [id]
     * @return: com.ovopark.privilege.server.model.entity.Product
     * @author wxb
     * @date: 2020/9/22 14:07
     */
    @Override
    public ProductPojo getProductById(Integer id) {
        ProductPojo productPojo = new ProductPojo();
        if (id != null){
            Product product =  this.baseMapper.selectById(id);
            if (product != null){
                BeanUtils.copyProperties(product,productPojo);
            }
        }
        return productPojo;
    }

    /**
     * @description: 获取所有产品
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.Product>
     * @author wxb
     * @date: 2020/9/22 14:08
     */
    @Override
    public List<ProductPojo> getAllProduct() {
        List<ProductPojo> productPojos = new ArrayList<>();
        List<Product> products = new ArrayList<>();
        products = this.baseMapper.selectList(new LambdaQueryWrapper<>());
        if (CollectionUtils.isNotEmpty(products)){
            for (Product product : products){
                ProductPojo productPojo = new ProductPojo();
                if (product != null){
                    BeanUtils.copyProperties(product,productPojo);
                    productPojos.add(productPojo);
                }
            }
        }
        return productPojos;
    }
}
