package com.ovopark.privilege.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.ProjectPrivilegesMapper;
import com.ovopark.privilege.model.entity.ProjectPrivileges;
import com.ovopark.privilege.service.ProjectPrivilegesService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wxb
 * @Title: ProjectPrivilegesServiceImpl
 * @Description: 方案权限
 * @date 2020/10/13 16:11
 **/
@Service
public class ProjectPrivilegesServiceImpl extends ServiceImpl<ProjectPrivilegesMapper, ProjectPrivileges> implements ProjectPrivilegesService {

    /**
     * @description: 新增
     * @param: [projectPrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 16:13
     */
    @Override
    public void insertProjectPrivileges(ProjectPrivileges projectPrivileges) {
        this.baseMapper.insert(projectPrivileges);
    }

    /**
     * @description: 更新
     * @param: [projectPrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 16:13
     */
    @Override
    public void updateProjectPrivileges(ProjectPrivileges projectPrivileges) {
        if (projectPrivileges.getId() != null){
            this.baseMapper.updateById(projectPrivileges);
        }
    }

    /**
     * @description: 删除
     * @param: [projectId]
     * @return: void
     * @author wxb
     * @date: 2020/10/13 16:13
     */
    @Override
    public void deleteProjectPrivilegesByProjectId(Integer projectId) {
        LambdaQueryWrapper<ProjectPrivileges> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectPrivileges::getProjectId,projectId);
        this.baseMapper.delete(queryWrapper);
    }

    /** 
     * @description: 获取方案权限
     * @param: [projectId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.ProjectPrivileges>
     * @author wxb
     * @date: 2020/10/13 19:49
     */ 
    @Override
    public List<ProjectPrivileges> getPlanPrivileges(Integer projectId) {
        LambdaQueryWrapper<ProjectPrivileges> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectPrivileges::getProjectId,projectId);
        return this.baseMapper.selectList(queryWrapper);
    }
}
