package com.ovopark.privilege.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.RolePrivilegesMapper;
import com.ovopark.privilege.model.entity.RolePrivileges;
import com.ovopark.privilege.service.RolePrivilegesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 用户表 服务实现类
 * </p>
 *
 * @author wxb
 * @since 2020-09-10
 */
@Slf4j
@Service
public class RolePrivilegesServiceImpl extends ServiceImpl<RolePrivilegesMapper, RolePrivileges> implements RolePrivilegesService {

    /**
     * @description: 根据角色id获取角色权限
     * @param: [roleId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.RolePrivileges>
     * @author wxb
     * @date: 2020/10/28 9:25
     */
    @Override
    public List<RolePrivileges> getRolePrivilegesByRoleId(Integer roleId) {
        LambdaQueryWrapper<RolePrivileges> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RolePrivileges::getRoleId,roleId);
        return this.baseMapper.selectList(queryWrapper);
    }

    /**
     * @description: 获取权限id根据角色id
     * @param: [roleId]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 9:25
     */
    @Override
    public List<Integer> getPrivilegeIdsByRoleId(Integer roleId) {
        List<RolePrivileges> rolePrivileges = new ArrayList<>();
        List<Integer> privilegeIds = new ArrayList<>();
        if (roleId != null){
            rolePrivileges = this.getRolePrivilegesByRoleId(roleId);
        }
        if (CollectionUtils.isNotEmpty(rolePrivileges)){
            for (RolePrivileges rolePrivilege : rolePrivileges){
                privilegeIds.add(rolePrivilege.getPrivilegeId());
            }
        }
        return privilegeIds;
    }

    /**
     * @description: 删除角色权限
     * @param: [roleId, privilegeIds]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 9:29
     */
    @Override
    public void batchDeleteRolePrivilegesByPrivilegeIds(Integer roleId, List<Integer> privilegeIds) {
        if (roleId != null && CollectionUtils.isNotEmpty(privilegeIds)){
            LambdaQueryWrapper<RolePrivileges> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(RolePrivileges::getRoleId,roleId).in(RolePrivileges::getPrivilegeId,privilegeIds);
            this.baseMapper.delete(queryWrapper);
        }
    }

    /**
     * @description: 新增角色权限
     * @param: [rolePrivileges]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 9:33
     */
    @Override
    public void insterRolePrivileges(RolePrivileges rolePrivileges) {
        if (rolePrivileges != null){
            this.baseMapper.insert(rolePrivileges);
        }
    }

    /**
     * @description: 获取角色的权限id
     * @param: [roleIds]
     * @return: java.util.List<java.lang.Integer>
     * @author wxb
     * @date: 2020/10/28 13:52
     */
    @Override
    public List<Integer> getPrivilegeIdsByRoles(List<Integer> roleIds) {
        return this.baseMapper.getPrivilegeIdsByRoles(roleIds);
    }

    /**
     * @description: 删除角色权限
     * @param: [roleId]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 14:49
     */
    @Override
    public void deleteRolePrivilegesByRoleId(Integer roleId) {
        if (roleId != null){
            LambdaQueryWrapper<RolePrivileges> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(RolePrivileges::getRoleId,roleId);
            this.baseMapper.delete(queryWrapper);
        }
    }
}
