package com.ovopark.privilege.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.SignUsersMapper;
import com.ovopark.privilege.model.entity.SignUsers;
import com.ovopark.privilege.service.SignUsersService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 用户中间表 服务实现类
 * </p>
 *
 * @author wxb
 * @since 2020-09-10
 */
@Slf4j
@Service
public class SignUsersServiceImpl extends ServiceImpl<SignUsersMapper, SignUsers> implements SignUsersService {

    /**
     * @description: 根据用户名和企业ID获取用户
     * @param: [userName, groupId]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:14
     */
    @Override
    public SignUsers getSignUserByUserNameAndGroupId(String userName, Integer groupId) {
        LambdaQueryWrapper<SignUsers> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SignUsers::getUserName,userName).eq(SignUsers::getEnterpriseId,groupId);
        return this.baseMapper.selectOne(queryWrapper);
    }

    /**
     * @description: 根据用户名获取用户
     * @param: [userName]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:14
     */
    @Override
    public SignUsers getSignUserByUserName(String userName) {
        LambdaQueryWrapper<SignUsers> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SignUsers::getUserName,userName);
        List<SignUsers> signUsers = this.baseMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(signUsers)){
            return signUsers.get(0);
        }
        return null;
    }

    /**
     * @description: 根据邮箱获取用户
     * @param: [email]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:14
     */
    @Override
    public SignUsers getSignUserByEmail(String email) {
        LambdaQueryWrapper<SignUsers> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SignUsers::getEmail,email);
        List<SignUsers> signUsers = this.baseMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(signUsers)){
            return signUsers.get(0);
        }
        return null;
    }

    /**
     * @description: 根据手机号获取用户
     * @param: [phone]
     * @return: com.ovopark.privilege.server.model.entity.SignUsers
     * @author wxb
     * @date: 2020/9/17 15:14
     */
    @Override
    public SignUsers getSignUserByPhone(String phone) {
        LambdaQueryWrapper<SignUsers> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SignUsers::getPhone,phone);
        List<SignUsers> signUsers = this.baseMapper.selectList(queryWrapper);
        if (CollectionUtils.isNotEmpty(signUsers)){
            return signUsers.get(0);
        }
        return null;
    }
}
