package com.ovopark.privilege.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.UserEnterpriseMapper;
import com.ovopark.privilege.model.entity.UserEnterprise;
import com.ovopark.privilege.service.UserEnterpriseService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


/**
 * <p>
 * 用户企业表 服务实现类
 * </p>
 *
 * @author wxb
 * @since 2020-09-01
 */
@Slf4j
@Service
public class UserEnterpriseServiceImpl extends ServiceImpl<UserEnterpriseMapper, UserEnterprise> implements UserEnterpriseService {

    /**
     * @description: 根据用户id和企业id获取用户企业
     * @param: [userId, enterpriseId]
     * @return: com.ovopark.privilege.server.model.entity.UserEnterprise
     * @author wxb
     * @date: 2020/10/28 16:40
     */
    @Override
    public UserEnterprise getUserEnterpriseByUserIdAndEnterpriseId(Integer userId, Integer enterpriseId) {
        if (userId != null && enterpriseId != null){
            LambdaQueryWrapper<UserEnterprise> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(UserEnterprise::getUserId,userId).eq(UserEnterprise::getEnterpriseId,enterpriseId);
            this.baseMapper.selectOne(queryWrapper);
        }
        return null;
    }

    /**
     * @description: 更新用户企业
     * @param: [userEnterprise]
     * @return: void
     * @author wxb
     * @date: 2020/10/28 16:43
     */
    @Override
    public void updateUserEnterpriseById(UserEnterprise userEnterprise) {
        if (userEnterprise != null){
            this.baseMapper.updateById(userEnterprise);
        }
    }
}
