package com.ovopark.privilege.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.UserRecentModuleMapper;
import com.ovopark.privilege.model.entity.UserRecentModule;
import com.ovopark.privilege.model.pojo.PrivilegesPojo;
import com.ovopark.privilege.service.UserRecentModuleService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 用户常用模块
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/9/22 14:07
 */
@Service
public class UserRecentModuleServiceImpl extends ServiceImpl<UserRecentModuleMapper, UserRecentModule> implements UserRecentModuleService {

    /**
     * @description: 获取用户常用模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentModule>
     * @author wxb
     * @date: 2020/11/3 23:20
     */
    @Override
    public List<PrivilegesPojo> getUserRecentModulePrivileges(Integer userId) {
        if (userId != null){
            return this.baseMapper.getUserRecentModulePrivileges(userId);
        }
        return null;
    }

    /** 
     * @description: 获取用户常用模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentModule>
     * @author wxb
     * @date: 2020/11/4 0:11
     */ 
    @Override
    public List<UserRecentModule> getUserRecentModules(Integer userId) {
        if (userId != null){
            LambdaQueryWrapper<UserRecentModule> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(UserRecentModule::getUserId,userId);
            return this.baseMapper.selectList(queryWrapper);
        }
        return null;
    }

    /** 
     * @description: 更新用户常用模块
     * @param: [userRecentModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:02
     */ 
    @Override
    public void updateUserRecentModule(UserRecentModule userRecentModule) {
        if (userRecentModule != null){
            this.baseMapper.updateById(userRecentModule);
        }
    }

    /** 
     * @description: 删除用户常用模块
     * @param: [userRecentModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:03
     */ 
    @Override
    public void deleteUserRecentModule(UserRecentModule userRecentModule) {
        if (userRecentModule != null){
            this.baseMapper.deleteById(userRecentModule);
        }
    }

    /**
     * @description: 新增常用模块
     * @param: [userRecentModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/5 13:10
     */
    @Override
    public void insterUserRecentModule(UserRecentModule userRecentModule) {
        if (userRecentModule != null){
            this.baseMapper.insert(userRecentModule);
        }
    }
}
