package com.ovopark.privilege.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.UserRecentProductMapper;
import com.ovopark.privilege.model.entity.UserRecentProduct;
import com.ovopark.privilege.service.UserRecentProductService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 产品
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/9/22 14:07
 */
@Service
public class UserRecentProductServiceImpl extends ServiceImpl<UserRecentProductMapper, UserRecentProduct> implements UserRecentProductService {

    /**
     * @description: 获取订阅模块 根据id
     * @param: [id]
     * @return: com.ovopark.privilege.server.model.entity.UserRecentProduct
     * @author wxb
     * @date: 2020/10/29 11:08
     */
    @Override
    public UserRecentProduct getUserRecentProductById(Integer id) {
        if (id != null){
            return this.baseMapper.selectById(id);
        }
        return null;
    }

    /**
     * @description: 获取用户订阅产品
     * @param: []
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserRecentProduct>
     * @author wxb
     * @date: 2020/10/29 10:25
     */
    @Override
    public List<UserRecentProduct> getUserRecentProductList(Integer userId) {
        if (userId != null){
            LambdaQueryWrapper<UserRecentProduct> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(UserRecentProduct::getUserId,userId).orderByAsc(UserRecentProduct::getIsOrder);
            return this.baseMapper.selectList(queryWrapper);
        }
        return null;
    }

    /**
     * @description: 更新用户订阅的产品
     * @param: [userRecentProduct]
     * @return: void
     * @author wxb
     * @date: 2020/10/29 10:25
     */
    @Override
    public void updateUserRecentProduct(UserRecentProduct userRecentProduct) {
        if (userRecentProduct != null){
            this.baseMapper.updateById(userRecentProduct);
        }
    }

    /**
     * @description: 取消订阅的产品
     * @param: [userRecentProduct]
     * @return: void
     * @author wxb
     * @date: 2020/10/29 17:07
     */
    @Override
    public void deleteUserRecentProduct(UserRecentProduct userRecentProduct) {
        if (userRecentProduct != null){
            this.baseMapper.deleteById(userRecentProduct);
        }
    }

    /**
     * @description:
     * @param: [userRecentProduct]
     * @return: void
     * @author wxb
     * @date: 2020/11/7 15:25
     */
    @Override
    public void insterUserRecentProduct(UserRecentProduct userRecentProduct) {
        if (userRecentProduct != null){
            this.baseMapper.insert(userRecentProduct);
        }
    }
}
