package com.ovopark.privilege.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.privilege.mapper.UserSubscribeModuleMapper;
import com.ovopark.privilege.model.entity.UserSubscribeModule;
import com.ovopark.privilege.model.pojo.PrivilegesPojo;
import com.ovopark.privilege.service.UserSubscribeModuleService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 用户订阅模块
 * @param:
 * @return:
 * @author wxb
 * @date: 2020/9/22 14:07
 */
@Service
public class UserSubscribeModuleServiceImpl extends ServiceImpl<UserSubscribeModuleMapper, UserSubscribeModule> implements UserSubscribeModuleService {

    /**
     * @description: 获取用户订阅模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserSubscribeModule>
     * @author wxb
     * @date: 2020/11/3 23:20
     */
    @Override
    public List<PrivilegesPojo> getUserSubscribeModulePrivileges(Integer userId) {
        if (userId != null){
            return this.baseMapper.getUserSubscribeModulePrivileges(userId);
        }
        return null;
    }

    /** 
     * @description: 获取用户订阅模块
     * @param: [userId]
     * @return: java.util.List<com.ovopark.privilege.server.model.entity.UserSubscribeModule>
     * @author wxb
     * @date: 2020/11/4 0:11
     */ 
    @Override
    public List<UserSubscribeModule> getUserSubscribeModules(Integer userId) {
        if (userId != null){
            LambdaQueryWrapper<UserSubscribeModule> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(UserSubscribeModule::getUserId,userId);
            return this.baseMapper.selectList(queryWrapper);
        }
        return null;
    }

    /** 
     * @description: 更新用户订阅模块
     * @param: [userSubscribeModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:02
     */ 
    @Override
    public void updateUserSubscribeModule(UserSubscribeModule userSubscribeModule) {
        if (userSubscribeModule != null){
            this.baseMapper.updateById(userSubscribeModule);
        }
    }

    /** 
     * @description: 删除用户订阅模块
     * @param: [userSubscribeModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/4 2:03
     */ 
    @Override
    public void deleteUserSubscribeModule(UserSubscribeModule userSubscribeModule) {
        if (userSubscribeModule != null){
            this.baseMapper.deleteById(userSubscribeModule);
        }
    }

    /**
     * @description: 新增订阅模块
     * @param: [userSubscribeModule]
     * @return: void
     * @author wxb
     * @date: 2020/11/5 13:10
     */
    @Override
    public void insterUserSubscribeModule(UserSubscribeModule userSubscribeModule) {
        if (userSubscribeModule != null){
            this.baseMapper.insert(userSubscribeModule);
        }
    }
}
