/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pojo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.pojo.JsonResult;

public class BaseResult<T> {
    private static final long serialVersionUID = 1L;
    public static final String RESULT_SUCCESS = "\u64cd\u4f5c\u6210\u529f";
    public static final String RESULT_FAILED = "\u64cd\u4f5c\u5931\u8d25";
    public static final String RESULT_INVALID_TOKEN = "INVALID_TOKEN";
    public static final String RESULT_INVALID_PHONE_FORMAT = "INVALID_PHONE_FORMAT";
    public static final String RESULT_INVALID_PARAMETER = "INVALID_PARAMETER";
    public static final String RESULT_ORGANIZE_NOT_EXIST = "ORGANIZE_NOT_EXIST";
    public static final String RESULT_NOT_BELONG_TO_ANY_COMPANY = "NOT_BELONG_TO_ANY_COMPANY";
    public static final String RESULT_NOT_LOGIN = "LOGIN_OUT";
    public static final String RESULT_TASK_NOT_EXIST = "TASK_NOT_EXIST";
    private String result;
    private String codename;
    private String code;
    private T data;
    private Boolean isError;

    public BaseResult() {
    }

    public BaseResult(String code, String codename, String result, T data, Boolean isError) {
        this.code = code;
        this.codename = codename;
        this.result = result;
        this.data = data;
        this.isError = isError;
    }

    public static BaseResult newInstance(String code, String codename, String result, Object data, Boolean isError) {
        return new BaseResult<Object>(code, codename, result, data, isError);
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.newInstance("0", "SUCCESS", RESULT_SUCCESS, null, false);
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.newInstance("0", "SUCCESS", RESULT_SUCCESS, data, false);
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.newInstance("20002", RESULT_INVALID_PARAMETER, RESULT_FAILED, null, true);
    }

    public static String invalidToken() {
        return JSONObject.toJSONString((Object)BaseResult.newInstance("200001", RESULT_INVALID_TOKEN, RESULT_FAILED, null, true));
    }

    public String getCodename() {
        return this.codename;
    }

    public void setCodename(String codename) {
        this.codename = codename;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static void main(String[] args) {
        JsonResult t = new JsonResult();
        t.setIsError(false);
        t.setResult(null);
        System.out.println(JSON.toJSONString((Object)t));
        System.out.println(BaseResult.success(t));
    }

    public abstract class CommonMessage {
        public static final String SUCCESS = "SUCCESS";
        public static final String ERROR = "\u8bf7\u6c42\u6570\u636e\u5931\u8d25";
        public static final String IS_EXIST = "\u8bb0\u5f55\u5df2\u5b58\u5728";
        public static final String INVALID_TOKEN = "\u65e0\u6548\u7684token";
        public static final String PARAM_ERROR = "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef";
        public static final String DELETE_FAILE = "\u5220\u9664\u5931\u8d25";
        public static final String TIME_OVER_ERROR = "TIME_OVER_ERROR";
        public static final String RESULT_NO_DATA = "NO_DATA";
        public static final String RESULT_DUPLICATE = "DUPLICATE";
        public static final String POINT_EXCEED_LIMIT = "EXCEED_LIMIT";
    }

    public abstract class CommonCode {
        public static final String SUCCESS = "0";
        public static final String ERROR = "1";
        public static final String RESULT_ORGANIZE_NOT_EXIST = "20000";
        public static final String INVALID_TOKEN = "200001";
        public static final String PARAM_ERROR = "20002";
        public static final String NO_DATA = "20002";
    }
}

