/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pojo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ovopark.exception.ResultCodeInfo;
import java.io.Serializable;
import java.util.HashMap;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

public class JsonResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String RESULT_SUCCESS = "ok";
    public static final String RESULT_FAILED = "FAILED";
    public static final String RESULT_INVALID_TOKEN = "INVALID_TOKEN";
    public static final String RESULT_EXCEPTION = "EXCEPTION";
    public static final String RESULT_INVALID_PARAMETER = "INVALID_PARAMETER";
    public static final String RESULT_ILLEGAL_DATA = "ILLEGAL_DATA";
    public static final String RESULT_EXIST_DATA = "EXIST_DATA";
    public static final String RESULT_INVALID_PRIVILEGE = "INVALID_PRIVILEGE";
    public static final String RESULT_PARAMETER_OUT_OF_RANGE_LIMIT = "PARAMETER_OUT_OF_RANGE_LIMIT";
    public static final String RESULT_INVALID_ACCESS_TOKEN = "INVALID_ACCESS_TOKEN";
    public static final String RESULT_INVALID_TIME_PARAMETER = "INVALID_TIME_PARAMETER";
    public static final String RESULT_INVALID_TIME_END_BEFORE_NOW = "INVALID_TIME_END_BEFORE_NOW";
    public static final String RESULT_INVALID_TIME_MORE_THAN_ONE_YEAR = "INVALID_TIME_MORE_THAN_ONE_YEAR";
    public static final String RESULT_INVALID_TIME_MORE_THAN_THREE_MONTHS = "RESULT_INVALID_TIME_MORE_THAN_THREE_MONTHS";
    public static final String TEMPLATE_IS_EDITED = "TEMPLATE_IS_EDITED";
    public static final String RESULT_TASK_FINISHED = "RESULT_TASK_FINISHED";
    public static final String RESULT_TASK_REJECTED = "RESULT_TASK_REJECTED";
    public static final String RESULT_TASK_NOT_EXIST = "TASK_NOT_EXIST";
    public static final String RESULT_TASK_IS_CLOSED = "TASK_IS_CLOSED";
    public static final String RESULT_TASK_IS_DELETED = "TASK_IS_DELETED";
    public static final String OVERDUE_UNENFORCEABLE = "Overdue_Unenforceable";
    public static final String OVERDUE_ADD_TIME_UNENFORCEABLE = "OVERDUE_ADD_TIME_UNENFORCEABLE";
    public static final String RESULT_TASK_IS_EXECUTED = "TASK_IS_EXECUTED";
    public static final String RESULT_TASK_CANNOT_EXECUTE = "TASK_CANNOT_EXECUTE";
    public static final String CANNOT_SUBMIT_REPEATEDLY_DURING_TASK_PROCESSING = "CANNOT_SUBMIT_REPEATEDLY_DURING_TASK_PROCESSING";
    public static final String READ_TASK_CANNOT_SUBMIT = "READ_TASK_CANNOT_SUBMIT";
    public static final String CANNOT_SUBMIT_AFTER_REJECTION = "CANNOT_SUBMIT_AFTER_REJECTION";
    public static final String TASK_USER_IS_FORWARDED = "TASK_USER_IS_FORWARDED";
    public static final String TASK_DEP_IS_NOT_EXECUTING = "TASK_DEP_IS_NOT_EXECUTING";
    public static final String TASK_DEP_IS_NOT_EXIST = "TASK_DEP_IS_NOT_EXIST";
    public static final String TASK_CANNOT_REJECT_EXECUTION = "TASK_CANNOT_REJECT_EXECUTION";
    public static final String IMPORT_TASK_IS_EMPTY = "IMPORT_TASK_IS_EMPTY";
    public static final String IMPORT_TASK_EXCEEDS_QUANTITY_LIMIT = "IMPORT_TASK_EXCEEDS_QUANTITY_LIMIT";
    public static final String IMPORT_TASK_EXCEL_INPUT_ERROR = "IMPORT_TASK_EXCEL_INPUT_ERROR";
    public static final String RESULT_EXECUTION_TASK_IS_READ = "RESULT_EXECUTION_TASK_IS_READ";
    public static final String RESULT_TASK_IS_EXCEED_TIME_LIMIT_INSPECTION_TIME = "RESULT_TASK_IS_EXCEED_TIME_LIMIT_INSPECTION_TIME";
    public static final String RESULT_TEMPLATE_ROLE_NOT_EXIST = "TEMPLATE_ROLE_NOT_EXIST";
    public static final String RESULT_THIS_DATA_NOT_SUPPORT_UPDATING = "THIS_DATA_NOT_SUPPORT_UPDATING";
    private String result;
    private HashMap<String, Object> data = new HashMap();
    private Boolean isError;
    private Long timeStamp;
    private String desc;

    public JsonResult() {
    }

    public JsonResult(String result, HashMap<String, Object> data, Boolean isError) {
        this.result = result;
        this.data = data;
        this.isError = isError;
    }

    public JsonResult(String result, HashMap<String, Object> data, Boolean isError, String desc) {
        this.result = result;
        this.data = data;
        this.isError = isError;
        this.desc = desc;
    }

    public static JsonResult newInstance(String result, Object data, Boolean isError) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        map.put("requestId", MDC.get((String)"requestId"));
        return new JsonResult(result, map, isError);
    }

    public static JsonResult newInstance(String result, Object data, Boolean isError, String desc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        map.put("requestId", MDC.get((String)"requestId"));
        return new JsonResult(result, map, isError, desc);
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public HashMap<String, Object> getData() {
        return this.data;
    }

    public void setData(HashMap<String, Object> data) {
        this.data = data;
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static String success() {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_SUCCESS, null, false));
    }

    public static String success(Object data) {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_SUCCESS, data, false), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static String successMapNullValue(Object data) {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_SUCCESS, data, false), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue});
    }

    public static String paramError() {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_INVALID_PARAMETER, null, true));
    }

    public static String error() {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_FAILED, null, true));
    }

    public static String error(String result) {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(result, null, true));
    }

    public static String error(ResultCodeInfo resultCodeInfo) {
        String errorCode;
        if (resultCodeInfo == null) {
            return JsonResult.error();
        }
        String string = errorCode = resultCodeInfo.getCode() == null ? null : resultCodeInfo.getCode().toString();
        if (StringUtils.isEmpty((Object)errorCode)) {
            errorCode = RESULT_FAILED;
        }
        return JSONObject.toJSONString((Object)JsonResult.newInstance(errorCode, null, true, resultCodeInfo.getMessage()));
    }

    public static String invalidToken() {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_INVALID_TOKEN, null, true));
    }

    public static String invalidAccessToken() {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_INVALID_ACCESS_TOKEN, null, true));
    }

    public static String invalidPrivilege() {
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_INVALID_PRIVILEGE, null, true));
    }

    public static String error(String errorCode, Object data) {
        if (StringUtils.isEmpty((Object)errorCode)) {
            errorCode = RESULT_FAILED;
        }
        return JSONObject.toJSONString((Object)JsonResult.newInstance(errorCode, data, true));
    }

    public static String success(String successCode, Object data) {
        if (StringUtils.isEmpty((Object)successCode)) {
            successCode = RESULT_SUCCESS;
        }
        return JSONObject.toJSONString((Object)JsonResult.newInstance(RESULT_SUCCESS, data, false));
    }

    public static JsonResult jrparamError() {
        return JsonResult.newInstance(RESULT_INVALID_PARAMETER, null, true);
    }

    public static JsonResult jrSuccess() {
        return JsonResult.newInstance(RESULT_SUCCESS, null, false);
    }

    public static JsonResult jrSuccess(Object data) {
        return JsonResult.newInstance(RESULT_SUCCESS, data, false);
    }

    public static JsonResult jrError() {
        return JsonResult.newInstance(RESULT_FAILED, null, true);
    }

    public static JsonResult jrError(String errorCode, Object data) {
        if (StringUtils.isEmpty((Object)errorCode)) {
            errorCode = RESULT_FAILED;
        }
        return JsonResult.newInstance(errorCode, data, true);
    }

    public static void main(String[] args) {
        JsonResult t = new JsonResult();
        t.setIsError(false);
        t.setResult(null);
        System.out.println(JSON.toJSONString((Object)t));
        System.out.println(JsonResult.success(t));
    }
}

