/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final String excel2003L = ".xls";
    private static final String excel2007U = ".xlsx";
    private static final int EXCEL_MAX_ROW = 60000;
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static List<List<Object>> getBankListByExcel(InputStream in, String fileName, Integer sheetId) throws Exception {
        ArrayList<List<Object>> list = null;
        Workbook work = ExcelUtil.getWorkbook(in, fileName);
        if (null == work) {
            throw new Exception("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
        }
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        list = new ArrayList<List<Object>>();
        if (sheetId == null) {
            for (int i = 0; i < work.getNumberOfSheets(); ++i) {
                sheet = work.getSheetAt(i);
                if (sheet == null) continue;
                for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                    row = sheet.getRow(j);
                    if (row == null) continue;
                    ArrayList<Object> li = new ArrayList<Object>();
                    for (int y = row.getFirstCellNum(); y < row.getLastCellNum(); ++y) {
                        cell = row.getCell(y);
                        li.add(ExcelUtil.getCellValue(cell));
                    }
                    list.add(li);
                }
            }
        } else {
            sheet = work.getSheetAt(sheetId.intValue());
            for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<Object> li = new ArrayList<Object>();
                for (int y = row.getFirstCellNum(); y < row.getLastCellNum(); ++y) {
                    cell = row.getCell(y);
                    li.add(ExcelUtil.getCellValue(cell));
                }
                list.add(li);
            }
        }
        return list;
    }

    public static List<Row> getRowsByExcel(Workbook work) throws Exception {
        ArrayList<Row> rows = null;
        if (null == work) {
            throw new Exception("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
        }
        Sheet sheet = work.getSheetAt(0);
        if (sheet == null) {
            return rows;
        }
        for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
            Row row = sheet.getRow(j);
            if (row == null || ExcelUtil.isRowEmpty(row)) continue;
            if (rows == null) {
                rows = new ArrayList<Row>();
            }
            rows.add(row);
        }
        work.close();
        return rows;
    }

    public static Workbook getWorkbook(InputStream inStr, String fileName) throws Exception {
        HSSFWorkbook wb;
        String fileType = fileName.substring(fileName.lastIndexOf("."));
        if (excel2003L.equals(fileType)) {
            wb = new HSSFWorkbook(inStr);
        } else if (excel2007U.equals(fileType)) {
            wb = new XSSFWorkbook(inStr);
        } else {
            throw new Exception("\u89e3\u6790\u7684\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff01");
        }
        return wb;
    }

    public static Object getCellValue(Cell cell) {
        Object value = null;
        if (cell != null) {
            DecimalFormat df = new DecimalFormat("#.#####");
            SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd");
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DecimalFormat df2 = new DecimalFormat("0.00");
            switch (cell.getCellType()) {
                case 1: {
                    value = cell.getRichStringCellValue().getString();
                    break;
                }
                case 0: {
                    if ("General".equals(cell.getCellStyle().getDataFormatString())) {
                        value = df.format(cell.getNumericCellValue());
                        break;
                    }
                    if ("m/d/yy".equals(cell.getCellStyle().getDataFormatString())) {
                        value = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    if ("m/d/yy h:mm".equals(cell.getCellStyle().getDataFormatString())) {
                        value = sdf2.format(cell.getDateCellValue());
                        break;
                    }
                    value = df2.format(cell.getNumericCellValue());
                    break;
                }
                case 4: {
                    value = cell.getBooleanCellValue();
                    break;
                }
                case 3: {
                    value = "";
                    break;
                }
            }
        }
        return value;
    }

    public static String getCellValueV2(Cell cell) {
        Object result = "";
        if (cell != null) {
            switch (cell.getCellTypeEnum()) {
                case STRING: {
                    result = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat sdf = null;
                        sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date date = cell.getDateCellValue();
                        result = sdf.format(date);
                        break;
                    }
                    if (cell.getCellStyle().getDataFormat() == 58) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        result = sdf.format(date);
                        break;
                    }
                    double value = cell.getNumericCellValue();
                    CellStyle style = cell.getCellStyle();
                    DecimalFormat format = new DecimalFormat();
                    String temp = style.getDataFormatString();
                    if (temp.equals("General")) {
                        format.applyPattern("#");
                    }
                    result = format.format(value);
                    break;
                }
                case BOOLEAN: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case FORMULA: {
                    result = cell.getNumericCellValue();
                    break;
                }
                case ERROR: {
                    result = cell.getErrorCellValue();
                    break;
                }
                case BLANK: {
                    break;
                }
            }
        }
        return result.toString();
    }

    private static boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        for (Cell cell : row) {
            if (cell == null || cell.getCellType() == CellType.BLANK.getCode()) continue;
            return false;
        }
        return true;
    }

    public static void insertFirstColumn(Workbook work, Map<Integer, List<String>> errorMsgMap, String errorTitle) {
        try {
            Sheet sheet = work.getSheetAt(0);
            Sheet newSheet = work.createSheet();
            int lastRowNum = sheet.getLastRowNum();
            Integer rowNum = 0;
            for (int i = lastRowNum; i >= 0; --i) {
                int lastCellNum;
                Row row = sheet.getRow(i);
                Row newRow = newSheet.createRow(i);
                if (row == null) continue;
                block10: for (int j = lastCellNum = row.getLastCellNum(); j > 0; --j) {
                    Cell oldCell = row.getCell(j - 1);
                    Cell cell = newRow.createCell(j);
                    if (oldCell == null) continue;
                    cell.setCellStyle(oldCell.getCellStyle());
                    switch (oldCell.getCellTypeEnum()) {
                        case STRING: {
                            cell.setCellValue(oldCell.getStringCellValue());
                            continue block10;
                        }
                        case NUMERIC: {
                            if (DateUtil.isCellDateFormatted((Cell)oldCell)) {
                                cell.setCellValue(oldCell.getDateCellValue());
                                continue block10;
                            }
                            cell.setCellValue(oldCell.getNumericCellValue());
                            continue block10;
                        }
                        case BOOLEAN: {
                            cell.setCellValue(oldCell.getBooleanCellValue());
                            continue block10;
                        }
                        case FORMULA: {
                            cell.setCellFormula(oldCell.getCellFormula());
                            continue block10;
                        }
                        case BLANK: {
                            continue block10;
                        }
                    }
                }
                if (i == 0) {
                    rowNum = row.getLastCellNum();
                    Cell titleCell = newRow.createCell(0);
                    titleCell.setCellValue(errorTitle);
                    Row oldRow = sheet.getRow(0);
                    if (oldRow == null) continue;
                    CellStyle cellStyle = oldRow.getCell(0).getCellStyle();
                    titleCell.setCellStyle(cellStyle);
                    continue;
                }
                Cell newFirstCell = newRow.createCell(0);
                if (errorMsgMap.get(i) != null) {
                    List<String> strings = errorMsgMap.get(i);
                    String string = strings.stream().collect(Collectors.joining(";\n"));
                    newFirstCell.setCellValue(string);
                    continue;
                }
                newFirstCell.setCellValue("");
            }
            List dataValidations = sheet.getDataValidations();
            for (DataValidation validation : dataValidations) {
                CellRangeAddressList oldAddresses = validation.getRegions();
                DataValidationConstraint validationConstraint = validation.getValidationConstraint();
                CellRangeAddressList newCellRangeAddressList = new CellRangeAddressList();
                for (CellRangeAddress cellRangeAddress : oldAddresses.getCellRangeAddresses()) {
                    CellRangeAddress newAddresses = new CellRangeAddress(cellRangeAddress.getFirstRow(), cellRangeAddress.getLastRow(), cellRangeAddress.getFirstColumn() + 1, cellRangeAddress.getLastColumn() + 1);
                    newCellRangeAddressList.addCellRangeAddress(newAddresses);
                }
                DataValidationHelper dataValidationHelper = newSheet.getDataValidationHelper();
                DataValidation newValidation = dataValidationHelper.createValidation(validationConstraint, newCellRangeAddressList);
                newSheet.addValidationData(newValidation);
            }
            int numberOfSheets = work.getNumberOfSheets() - 1;
            for (int i = 0; i < numberOfSheets; ++i) {
                work.removeSheetAt(0);
            }
            IntStream.range(0, rowNum + 1).forEach(it -> newSheet.setColumnWidth(it, 6400));
        }
        catch (Exception e) {
            log.error("insertFirstColumn error {}", (Throwable)e);
        }
    }
}

