/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.export.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.StringUtils;

public class StudentReportVo
implements Serializable {
    private static DateTimeFormatter DATE_TIME_FORMATRER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static Map<Integer, String> LEARN_STATUS_MAP = new HashMap<Integer, String>();
    private static Map<Integer, String> SHIFT_STATUS_MAP = new HashMap<Integer, String>();
    private static Map<Integer, String> PASS_STATUS_MAP = new HashMap<Integer, String>();
    private Integer enterpriseId;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    private String jobNumber;
    private String userName;
    private String parentName;
    private Integer userId;
    private Integer learnUserId;
    private String post;
    private Integer finishTask;
    private Integer learnTask;
    private Integer learnStatus;
    private String learnStatusDesc;
    private Integer taskStatus;
    private Integer passStatus;
    private String passStatusDesc;
    private Integer projectTaskScheduleId;
    private Integer shiftId;
    private String shiftName;
    private String groupName;
    private String supplemenName;
    private Integer taskType;
    private Integer creatorId;
    private String creatorName;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime shiftCreateTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime shiftStartTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime shiftEndTime;
    private Integer isNotimeLimit;
    private String shiftTermOfValidity;
    private Integer shiftStatus;
    private List<Integer> shiftStatuses;
    private String shiftStatusDesc;
    private Integer projectId;
    private String projectName;
    private Integer dutiesId;
    private String dutiesName;
    private String organizeName;
    private Double score;
    private Double xsScore;
    private Double xxScore;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime shiftStartCreateTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime shiftEndCreateTime;
    private List<Integer> creatorIds;
    private List<String> organizeIds;
    private String keyWord;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startLearnTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endLearnTime;
    private String shiftInfoDesc;
    private Integer sourceId;

    public String getShiftTermOfValidity() {
        if (this.shiftCreateTime != null) {
            this.shiftTermOfValidity = this.isNotimeLimit != null && this.isNotimeLimit == 1 ? DATE_TIME_FORMATRER.format(this.getShiftCreateTime()) + " -> \u65e0\u9650\u671f" : (this.shiftEndTime != null ? DATE_TIME_FORMATRER.format(this.getShiftCreateTime()) + " -> " + DATE_TIME_FORMATRER.format(this.shiftEndTime) : "-");
        }
        return this.shiftTermOfValidity;
    }

    public String getLearnStatusDesc() {
        this.learnStatusDesc = this.learnStatus != null ? LEARN_STATUS_MAP.get(this.learnStatus) + " " + (this.finishTask == null ? "0" : this.finishTask) + "/" + (this.learnTask == null ? "0" : this.learnTask) : "-";
        return this.learnStatusDesc;
    }

    public String getShiftStatusDesc() {
        if (this.shiftStatus != null) {
            this.shiftStatusDesc = SHIFT_STATUS_MAP.get(this.getShiftStatus());
        }
        return StringUtils.isEmpty((Object)this.shiftStatusDesc) ? "-" : this.shiftStatusDesc;
    }

    public String getPassStatusDesc() {
        if (this.passStatus != null) {
            this.passStatusDesc = PASS_STATUS_MAP.get(this.passStatus);
        }
        return StringUtils.isEmpty((Object)this.passStatusDesc) ? "-" : this.passStatusDesc;
    }

    public static String formatTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "-";
        }
        return DATE_TIME_FORMATRER.format(dateTime);
    }

    public String getShiftInfoDesc() {
        StringBuilder sb = new StringBuilder(this.shiftName).append("-").append(this.groupName);
        if (!StringUtils.isEmpty((Object)this.supplemenName)) {
            sb.append("-").append(this.supplemenName);
        }
        return sb.toString();
    }

    public Integer getEnterpriseId() {
        return this.enterpriseId;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public Integer getLearnUserId() {
        return this.learnUserId;
    }

    public String getPost() {
        return this.post;
    }

    public Integer getFinishTask() {
        return this.finishTask;
    }

    public Integer getLearnTask() {
        return this.learnTask;
    }

    public Integer getLearnStatus() {
        return this.learnStatus;
    }

    public Integer getTaskStatus() {
        return this.taskStatus;
    }

    public Integer getPassStatus() {
        return this.passStatus;
    }

    public Integer getProjectTaskScheduleId() {
        return this.projectTaskScheduleId;
    }

    public Integer getShiftId() {
        return this.shiftId;
    }

    public String getShiftName() {
        return this.shiftName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getSupplemenName() {
        return this.supplemenName;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Integer getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public LocalDateTime getShiftCreateTime() {
        return this.shiftCreateTime;
    }

    public LocalDateTime getShiftStartTime() {
        return this.shiftStartTime;
    }

    public LocalDateTime getShiftEndTime() {
        return this.shiftEndTime;
    }

    public Integer getIsNotimeLimit() {
        return this.isNotimeLimit;
    }

    public Integer getShiftStatus() {
        return this.shiftStatus;
    }

    public List<Integer> getShiftStatuses() {
        return this.shiftStatuses;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Integer getDutiesId() {
        return this.dutiesId;
    }

    public String getDutiesName() {
        return this.dutiesName;
    }

    public String getOrganizeName() {
        return this.organizeName;
    }

    public Double getScore() {
        return this.score;
    }

    public Double getXsScore() {
        return this.xsScore;
    }

    public Double getXxScore() {
        return this.xxScore;
    }

    public LocalDateTime getShiftStartCreateTime() {
        return this.shiftStartCreateTime;
    }

    public LocalDateTime getShiftEndCreateTime() {
        return this.shiftEndCreateTime;
    }

    public List<Integer> getCreatorIds() {
        return this.creatorIds;
    }

    public List<String> getOrganizeIds() {
        return this.organizeIds;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public LocalDateTime getStartLearnTime() {
        return this.startLearnTime;
    }

    public LocalDateTime getEndLearnTime() {
        return this.endLearnTime;
    }

    public Integer getSourceId() {
        return this.sourceId;
    }

    public void setEnterpriseId(Integer enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setJobNumber(String jobNumber) {
        this.jobNumber = jobNumber;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setLearnUserId(Integer learnUserId) {
        this.learnUserId = learnUserId;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public void setFinishTask(Integer finishTask) {
        this.finishTask = finishTask;
    }

    public void setLearnTask(Integer learnTask) {
        this.learnTask = learnTask;
    }

    public void setLearnStatus(Integer learnStatus) {
        this.learnStatus = learnStatus;
    }

    public void setLearnStatusDesc(String learnStatusDesc) {
        this.learnStatusDesc = learnStatusDesc;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setPassStatus(Integer passStatus) {
        this.passStatus = passStatus;
    }

    public void setPassStatusDesc(String passStatusDesc) {
        this.passStatusDesc = passStatusDesc;
    }

    public void setProjectTaskScheduleId(Integer projectTaskScheduleId) {
        this.projectTaskScheduleId = projectTaskScheduleId;
    }

    public void setShiftId(Integer shiftId) {
        this.shiftId = shiftId;
    }

    public void setShiftName(String shiftName) {
        this.shiftName = shiftName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setSupplemenName(String supplemenName) {
        this.supplemenName = supplemenName;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setCreatorId(Integer creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setShiftCreateTime(LocalDateTime shiftCreateTime) {
        this.shiftCreateTime = shiftCreateTime;
    }

    public void setShiftStartTime(LocalDateTime shiftStartTime) {
        this.shiftStartTime = shiftStartTime;
    }

    public void setShiftEndTime(LocalDateTime shiftEndTime) {
        this.shiftEndTime = shiftEndTime;
    }

    public void setIsNotimeLimit(Integer isNotimeLimit) {
        this.isNotimeLimit = isNotimeLimit;
    }

    public void setShiftTermOfValidity(String shiftTermOfValidity) {
        this.shiftTermOfValidity = shiftTermOfValidity;
    }

    public void setShiftStatus(Integer shiftStatus) {
        this.shiftStatus = shiftStatus;
    }

    public void setShiftStatuses(List<Integer> shiftStatuses) {
        this.shiftStatuses = shiftStatuses;
    }

    public void setShiftStatusDesc(String shiftStatusDesc) {
        this.shiftStatusDesc = shiftStatusDesc;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDutiesId(Integer dutiesId) {
        this.dutiesId = dutiesId;
    }

    public void setDutiesName(String dutiesName) {
        this.dutiesName = dutiesName;
    }

    public void setOrganizeName(String organizeName) {
        this.organizeName = organizeName;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setXsScore(Double xsScore) {
        this.xsScore = xsScore;
    }

    public void setXxScore(Double xxScore) {
        this.xxScore = xxScore;
    }

    public void setShiftStartCreateTime(LocalDateTime shiftStartCreateTime) {
        this.shiftStartCreateTime = shiftStartCreateTime;
    }

    public void setShiftEndCreateTime(LocalDateTime shiftEndCreateTime) {
        this.shiftEndCreateTime = shiftEndCreateTime;
    }

    public void setCreatorIds(List<Integer> creatorIds) {
        this.creatorIds = creatorIds;
    }

    public void setOrganizeIds(List<String> organizeIds) {
        this.organizeIds = organizeIds;
    }

    public void setKeyWord(String keyWord) {
        this.keyWord = keyWord;
    }

    public void setStartLearnTime(LocalDateTime startLearnTime) {
        this.startLearnTime = startLearnTime;
    }

    public void setEndLearnTime(LocalDateTime endLearnTime) {
        this.endLearnTime = endLearnTime;
    }

    public void setShiftInfoDesc(String shiftInfoDesc) {
        this.shiftInfoDesc = shiftInfoDesc;
    }

    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StudentReportVo)) {
            return false;
        }
        StudentReportVo other = (StudentReportVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$enterpriseId = this.getEnterpriseId();
        Integer other$enterpriseId = other.getEnterpriseId();
        if (this$enterpriseId == null ? other$enterpriseId != null : !((Object)this$enterpriseId).equals(other$enterpriseId)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$jobNumber = this.getJobNumber();
        String other$jobNumber = other.getJobNumber();
        if (this$jobNumber == null ? other$jobNumber != null : !this$jobNumber.equals(other$jobNumber)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$parentName = this.getParentName();
        String other$parentName = other.getParentName();
        if (this$parentName == null ? other$parentName != null : !this$parentName.equals(other$parentName)) {
            return false;
        }
        Integer this$userId = this.getUserId();
        Integer other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$learnUserId = this.getLearnUserId();
        Integer other$learnUserId = other.getLearnUserId();
        if (this$learnUserId == null ? other$learnUserId != null : !((Object)this$learnUserId).equals(other$learnUserId)) {
            return false;
        }
        String this$post = this.getPost();
        String other$post = other.getPost();
        if (this$post == null ? other$post != null : !this$post.equals(other$post)) {
            return false;
        }
        Integer this$finishTask = this.getFinishTask();
        Integer other$finishTask = other.getFinishTask();
        if (this$finishTask == null ? other$finishTask != null : !((Object)this$finishTask).equals(other$finishTask)) {
            return false;
        }
        Integer this$learnTask = this.getLearnTask();
        Integer other$learnTask = other.getLearnTask();
        if (this$learnTask == null ? other$learnTask != null : !((Object)this$learnTask).equals(other$learnTask)) {
            return false;
        }
        Integer this$learnStatus = this.getLearnStatus();
        Integer other$learnStatus = other.getLearnStatus();
        if (this$learnStatus == null ? other$learnStatus != null : !((Object)this$learnStatus).equals(other$learnStatus)) {
            return false;
        }
        String this$learnStatusDesc = this.getLearnStatusDesc();
        String other$learnStatusDesc = other.getLearnStatusDesc();
        if (this$learnStatusDesc == null ? other$learnStatusDesc != null : !this$learnStatusDesc.equals(other$learnStatusDesc)) {
            return false;
        }
        Integer this$taskStatus = this.getTaskStatus();
        Integer other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !((Object)this$taskStatus).equals(other$taskStatus)) {
            return false;
        }
        Integer this$passStatus = this.getPassStatus();
        Integer other$passStatus = other.getPassStatus();
        if (this$passStatus == null ? other$passStatus != null : !((Object)this$passStatus).equals(other$passStatus)) {
            return false;
        }
        String this$passStatusDesc = this.getPassStatusDesc();
        String other$passStatusDesc = other.getPassStatusDesc();
        if (this$passStatusDesc == null ? other$passStatusDesc != null : !this$passStatusDesc.equals(other$passStatusDesc)) {
            return false;
        }
        Integer this$projectTaskScheduleId = this.getProjectTaskScheduleId();
        Integer other$projectTaskScheduleId = other.getProjectTaskScheduleId();
        if (this$projectTaskScheduleId == null ? other$projectTaskScheduleId != null : !((Object)this$projectTaskScheduleId).equals(other$projectTaskScheduleId)) {
            return false;
        }
        Integer this$shiftId = this.getShiftId();
        Integer other$shiftId = other.getShiftId();
        if (this$shiftId == null ? other$shiftId != null : !((Object)this$shiftId).equals(other$shiftId)) {
            return false;
        }
        String this$shiftName = this.getShiftName();
        String other$shiftName = other.getShiftName();
        if (this$shiftName == null ? other$shiftName != null : !this$shiftName.equals(other$shiftName)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        String this$supplemenName = this.getSupplemenName();
        String other$supplemenName = other.getSupplemenName();
        if (this$supplemenName == null ? other$supplemenName != null : !this$supplemenName.equals(other$supplemenName)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Integer this$creatorId = this.getCreatorId();
        Integer other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        LocalDateTime this$shiftCreateTime = this.getShiftCreateTime();
        LocalDateTime other$shiftCreateTime = other.getShiftCreateTime();
        if (this$shiftCreateTime == null ? other$shiftCreateTime != null : !((Object)this$shiftCreateTime).equals(other$shiftCreateTime)) {
            return false;
        }
        LocalDateTime this$shiftStartTime = this.getShiftStartTime();
        LocalDateTime other$shiftStartTime = other.getShiftStartTime();
        if (this$shiftStartTime == null ? other$shiftStartTime != null : !((Object)this$shiftStartTime).equals(other$shiftStartTime)) {
            return false;
        }
        LocalDateTime this$shiftEndTime = this.getShiftEndTime();
        LocalDateTime other$shiftEndTime = other.getShiftEndTime();
        if (this$shiftEndTime == null ? other$shiftEndTime != null : !((Object)this$shiftEndTime).equals(other$shiftEndTime)) {
            return false;
        }
        Integer this$isNotimeLimit = this.getIsNotimeLimit();
        Integer other$isNotimeLimit = other.getIsNotimeLimit();
        if (this$isNotimeLimit == null ? other$isNotimeLimit != null : !((Object)this$isNotimeLimit).equals(other$isNotimeLimit)) {
            return false;
        }
        String this$shiftTermOfValidity = this.getShiftTermOfValidity();
        String other$shiftTermOfValidity = other.getShiftTermOfValidity();
        if (this$shiftTermOfValidity == null ? other$shiftTermOfValidity != null : !this$shiftTermOfValidity.equals(other$shiftTermOfValidity)) {
            return false;
        }
        Integer this$shiftStatus = this.getShiftStatus();
        Integer other$shiftStatus = other.getShiftStatus();
        if (this$shiftStatus == null ? other$shiftStatus != null : !((Object)this$shiftStatus).equals(other$shiftStatus)) {
            return false;
        }
        List<Integer> this$shiftStatuses = this.getShiftStatuses();
        List<Integer> other$shiftStatuses = other.getShiftStatuses();
        if (this$shiftStatuses == null ? other$shiftStatuses != null : !((Object)this$shiftStatuses).equals(other$shiftStatuses)) {
            return false;
        }
        String this$shiftStatusDesc = this.getShiftStatusDesc();
        String other$shiftStatusDesc = other.getShiftStatusDesc();
        if (this$shiftStatusDesc == null ? other$shiftStatusDesc != null : !this$shiftStatusDesc.equals(other$shiftStatusDesc)) {
            return false;
        }
        Integer this$projectId = this.getProjectId();
        Integer other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        Integer this$dutiesId = this.getDutiesId();
        Integer other$dutiesId = other.getDutiesId();
        if (this$dutiesId == null ? other$dutiesId != null : !((Object)this$dutiesId).equals(other$dutiesId)) {
            return false;
        }
        String this$dutiesName = this.getDutiesName();
        String other$dutiesName = other.getDutiesName();
        if (this$dutiesName == null ? other$dutiesName != null : !this$dutiesName.equals(other$dutiesName)) {
            return false;
        }
        String this$organizeName = this.getOrganizeName();
        String other$organizeName = other.getOrganizeName();
        if (this$organizeName == null ? other$organizeName != null : !this$organizeName.equals(other$organizeName)) {
            return false;
        }
        Double this$score = this.getScore();
        Double other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        Double this$xsScore = this.getXsScore();
        Double other$xsScore = other.getXsScore();
        if (this$xsScore == null ? other$xsScore != null : !((Object)this$xsScore).equals(other$xsScore)) {
            return false;
        }
        Double this$xxScore = this.getXxScore();
        Double other$xxScore = other.getXxScore();
        if (this$xxScore == null ? other$xxScore != null : !((Object)this$xxScore).equals(other$xxScore)) {
            return false;
        }
        LocalDateTime this$shiftStartCreateTime = this.getShiftStartCreateTime();
        LocalDateTime other$shiftStartCreateTime = other.getShiftStartCreateTime();
        if (this$shiftStartCreateTime == null ? other$shiftStartCreateTime != null : !((Object)this$shiftStartCreateTime).equals(other$shiftStartCreateTime)) {
            return false;
        }
        LocalDateTime this$shiftEndCreateTime = this.getShiftEndCreateTime();
        LocalDateTime other$shiftEndCreateTime = other.getShiftEndCreateTime();
        if (this$shiftEndCreateTime == null ? other$shiftEndCreateTime != null : !((Object)this$shiftEndCreateTime).equals(other$shiftEndCreateTime)) {
            return false;
        }
        List<Integer> this$creatorIds = this.getCreatorIds();
        List<Integer> other$creatorIds = other.getCreatorIds();
        if (this$creatorIds == null ? other$creatorIds != null : !((Object)this$creatorIds).equals(other$creatorIds)) {
            return false;
        }
        List<String> this$organizeIds = this.getOrganizeIds();
        List<String> other$organizeIds = other.getOrganizeIds();
        if (this$organizeIds == null ? other$organizeIds != null : !((Object)this$organizeIds).equals(other$organizeIds)) {
            return false;
        }
        String this$keyWord = this.getKeyWord();
        String other$keyWord = other.getKeyWord();
        if (this$keyWord == null ? other$keyWord != null : !this$keyWord.equals(other$keyWord)) {
            return false;
        }
        LocalDateTime this$startLearnTime = this.getStartLearnTime();
        LocalDateTime other$startLearnTime = other.getStartLearnTime();
        if (this$startLearnTime == null ? other$startLearnTime != null : !((Object)this$startLearnTime).equals(other$startLearnTime)) {
            return false;
        }
        LocalDateTime this$endLearnTime = this.getEndLearnTime();
        LocalDateTime other$endLearnTime = other.getEndLearnTime();
        if (this$endLearnTime == null ? other$endLearnTime != null : !((Object)this$endLearnTime).equals(other$endLearnTime)) {
            return false;
        }
        String this$shiftInfoDesc = this.getShiftInfoDesc();
        String other$shiftInfoDesc = other.getShiftInfoDesc();
        if (this$shiftInfoDesc == null ? other$shiftInfoDesc != null : !this$shiftInfoDesc.equals(other$shiftInfoDesc)) {
            return false;
        }
        Integer this$sourceId = this.getSourceId();
        Integer other$sourceId = other.getSourceId();
        return !(this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StudentReportVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $enterpriseId = this.getEnterpriseId();
        result = result * 59 + ($enterpriseId == null ? 43 : ((Object)$enterpriseId).hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $jobNumber = this.getJobNumber();
        result = result * 59 + ($jobNumber == null ? 43 : $jobNumber.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $parentName = this.getParentName();
        result = result * 59 + ($parentName == null ? 43 : $parentName.hashCode());
        Integer $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $learnUserId = this.getLearnUserId();
        result = result * 59 + ($learnUserId == null ? 43 : ((Object)$learnUserId).hashCode());
        String $post = this.getPost();
        result = result * 59 + ($post == null ? 43 : $post.hashCode());
        Integer $finishTask = this.getFinishTask();
        result = result * 59 + ($finishTask == null ? 43 : ((Object)$finishTask).hashCode());
        Integer $learnTask = this.getLearnTask();
        result = result * 59 + ($learnTask == null ? 43 : ((Object)$learnTask).hashCode());
        Integer $learnStatus = this.getLearnStatus();
        result = result * 59 + ($learnStatus == null ? 43 : ((Object)$learnStatus).hashCode());
        String $learnStatusDesc = this.getLearnStatusDesc();
        result = result * 59 + ($learnStatusDesc == null ? 43 : $learnStatusDesc.hashCode());
        Integer $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : ((Object)$taskStatus).hashCode());
        Integer $passStatus = this.getPassStatus();
        result = result * 59 + ($passStatus == null ? 43 : ((Object)$passStatus).hashCode());
        String $passStatusDesc = this.getPassStatusDesc();
        result = result * 59 + ($passStatusDesc == null ? 43 : $passStatusDesc.hashCode());
        Integer $projectTaskScheduleId = this.getProjectTaskScheduleId();
        result = result * 59 + ($projectTaskScheduleId == null ? 43 : ((Object)$projectTaskScheduleId).hashCode());
        Integer $shiftId = this.getShiftId();
        result = result * 59 + ($shiftId == null ? 43 : ((Object)$shiftId).hashCode());
        String $shiftName = this.getShiftName();
        result = result * 59 + ($shiftName == null ? 43 : $shiftName.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        String $supplemenName = this.getSupplemenName();
        result = result * 59 + ($supplemenName == null ? 43 : $supplemenName.hashCode());
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Integer $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        LocalDateTime $shiftCreateTime = this.getShiftCreateTime();
        result = result * 59 + ($shiftCreateTime == null ? 43 : ((Object)$shiftCreateTime).hashCode());
        LocalDateTime $shiftStartTime = this.getShiftStartTime();
        result = result * 59 + ($shiftStartTime == null ? 43 : ((Object)$shiftStartTime).hashCode());
        LocalDateTime $shiftEndTime = this.getShiftEndTime();
        result = result * 59 + ($shiftEndTime == null ? 43 : ((Object)$shiftEndTime).hashCode());
        Integer $isNotimeLimit = this.getIsNotimeLimit();
        result = result * 59 + ($isNotimeLimit == null ? 43 : ((Object)$isNotimeLimit).hashCode());
        String $shiftTermOfValidity = this.getShiftTermOfValidity();
        result = result * 59 + ($shiftTermOfValidity == null ? 43 : $shiftTermOfValidity.hashCode());
        Integer $shiftStatus = this.getShiftStatus();
        result = result * 59 + ($shiftStatus == null ? 43 : ((Object)$shiftStatus).hashCode());
        List<Integer> $shiftStatuses = this.getShiftStatuses();
        result = result * 59 + ($shiftStatuses == null ? 43 : ((Object)$shiftStatuses).hashCode());
        String $shiftStatusDesc = this.getShiftStatusDesc();
        result = result * 59 + ($shiftStatusDesc == null ? 43 : $shiftStatusDesc.hashCode());
        Integer $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        Integer $dutiesId = this.getDutiesId();
        result = result * 59 + ($dutiesId == null ? 43 : ((Object)$dutiesId).hashCode());
        String $dutiesName = this.getDutiesName();
        result = result * 59 + ($dutiesName == null ? 43 : $dutiesName.hashCode());
        String $organizeName = this.getOrganizeName();
        result = result * 59 + ($organizeName == null ? 43 : $organizeName.hashCode());
        Double $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        Double $xsScore = this.getXsScore();
        result = result * 59 + ($xsScore == null ? 43 : ((Object)$xsScore).hashCode());
        Double $xxScore = this.getXxScore();
        result = result * 59 + ($xxScore == null ? 43 : ((Object)$xxScore).hashCode());
        LocalDateTime $shiftStartCreateTime = this.getShiftStartCreateTime();
        result = result * 59 + ($shiftStartCreateTime == null ? 43 : ((Object)$shiftStartCreateTime).hashCode());
        LocalDateTime $shiftEndCreateTime = this.getShiftEndCreateTime();
        result = result * 59 + ($shiftEndCreateTime == null ? 43 : ((Object)$shiftEndCreateTime).hashCode());
        List<Integer> $creatorIds = this.getCreatorIds();
        result = result * 59 + ($creatorIds == null ? 43 : ((Object)$creatorIds).hashCode());
        List<String> $organizeIds = this.getOrganizeIds();
        result = result * 59 + ($organizeIds == null ? 43 : ((Object)$organizeIds).hashCode());
        String $keyWord = this.getKeyWord();
        result = result * 59 + ($keyWord == null ? 43 : $keyWord.hashCode());
        LocalDateTime $startLearnTime = this.getStartLearnTime();
        result = result * 59 + ($startLearnTime == null ? 43 : ((Object)$startLearnTime).hashCode());
        LocalDateTime $endLearnTime = this.getEndLearnTime();
        result = result * 59 + ($endLearnTime == null ? 43 : ((Object)$endLearnTime).hashCode());
        String $shiftInfoDesc = this.getShiftInfoDesc();
        result = result * 59 + ($shiftInfoDesc == null ? 43 : $shiftInfoDesc.hashCode());
        Integer $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        return result;
    }

    public String toString() {
        return "StudentReportVo(enterpriseId=" + this.getEnterpriseId() + ", createTime=" + this.getCreateTime() + ", jobNumber=" + this.getJobNumber() + ", userName=" + this.getUserName() + ", parentName=" + this.getParentName() + ", userId=" + this.getUserId() + ", learnUserId=" + this.getLearnUserId() + ", post=" + this.getPost() + ", finishTask=" + this.getFinishTask() + ", learnTask=" + this.getLearnTask() + ", learnStatus=" + this.getLearnStatus() + ", learnStatusDesc=" + this.getLearnStatusDesc() + ", taskStatus=" + this.getTaskStatus() + ", passStatus=" + this.getPassStatus() + ", passStatusDesc=" + this.getPassStatusDesc() + ", projectTaskScheduleId=" + this.getProjectTaskScheduleId() + ", shiftId=" + this.getShiftId() + ", shiftName=" + this.getShiftName() + ", groupName=" + this.getGroupName() + ", supplemenName=" + this.getSupplemenName() + ", taskType=" + this.getTaskType() + ", creatorId=" + this.getCreatorId() + ", creatorName=" + this.getCreatorName() + ", shiftCreateTime=" + this.getShiftCreateTime() + ", shiftStartTime=" + this.getShiftStartTime() + ", shiftEndTime=" + this.getShiftEndTime() + ", isNotimeLimit=" + this.getIsNotimeLimit() + ", shiftTermOfValidity=" + this.getShiftTermOfValidity() + ", shiftStatus=" + this.getShiftStatus() + ", shiftStatuses=" + this.getShiftStatuses() + ", shiftStatusDesc=" + this.getShiftStatusDesc() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", dutiesId=" + this.getDutiesId() + ", dutiesName=" + this.getDutiesName() + ", organizeName=" + this.getOrganizeName() + ", score=" + this.getScore() + ", xsScore=" + this.getXsScore() + ", xxScore=" + this.getXxScore() + ", shiftStartCreateTime=" + this.getShiftStartCreateTime() + ", shiftEndCreateTime=" + this.getShiftEndCreateTime() + ", creatorIds=" + this.getCreatorIds() + ", organizeIds=" + this.getOrganizeIds() + ", keyWord=" + this.getKeyWord() + ", startLearnTime=" + this.getStartLearnTime() + ", endLearnTime=" + this.getEndLearnTime() + ", shiftInfoDesc=" + this.getShiftInfoDesc() + ", sourceId=" + this.getSourceId() + ")";
    }

    static {
        LEARN_STATUS_MAP.put(0, "\u7b49\u5f85\u4e0a\u7ebf");
        LEARN_STATUS_MAP.put(1, "\u672a\u5f00\u59cb");
        LEARN_STATUS_MAP.put(2, "\u8fdb\u884c\u4e2d");
        LEARN_STATUS_MAP.put(3, "\u5df2\u5b8c\u6210");
        SHIFT_STATUS_MAP.put(0, "\u8349\u7a3f");
        SHIFT_STATUS_MAP.put(1, "\u5f85\u5f00\u8bfe");
        SHIFT_STATUS_MAP.put(2, "\u8bfe\u65f6\u4e2d");
        SHIFT_STATUS_MAP.put(3, "\u5f85\u7ed3\u73ed");
        SHIFT_STATUS_MAP.put(4, "\u5df2\u7ed3\u73ed");
        SHIFT_STATUS_MAP.put(5, "\u672a\u5f00\u59cb");
        SHIFT_STATUS_MAP.put(6, "\u8fdb\u884c\u4e2d");
        SHIFT_STATUS_MAP.put(7, "\u5df2\u7ed3\u675f");
        PASS_STATUS_MAP.put(0, "\u672a\u901a\u8fc7");
        PASS_STATUS_MAP.put(1, "\u901a\u8fc7");
    }
}

