/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.weixin.api;

import com.ovopark.weixin.mo.ExpireTimeMo;
import com.ovopark.weixin.mo.SimpleIdsMo;
import com.ovopark.weixin.mo.SystemConfigureMo;
import com.ovopark.weixin.response.BaseResult;
import com.ovopark.weixin.vo.LeaderOrganizeIdsMo;
import com.ovopark.weixin.vo.UserSaveVo;
import com.ovopark.weixin.vo.UsersSimpleVo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${WEIXIN_FEIGN:ovopark-weixin}")
public interface UserApi {
    @PostMapping(value={"/ovopark-weixin/user/saveUser"})
    public BaseResult<Map<String, String>> saveUser(@RequestBody UserSaveVo var1);

    @PostMapping(value={"/ovopark-weixin/user/saveUserByLogin"})
    public BaseResult<Map<String, String>> saveUserByLogin(@RequestBody UserSaveVo var1);

    @PostMapping(value={"/ovopark-weixin/user/updateWeixinUser"})
    public BaseResult<Integer> updateWeixinUser(@RequestParam(value="groupId") Integer var1);

    @GetMapping(value={"/ovopark-weixin/user/deleteByGroupIdAndUser"})
    public BaseResult deleteByGroupIdAndUser(@RequestParam(value="groupId") Integer var1, @RequestParam(value="trilateralId", required=false) String var2, @RequestParam(value="encryptionUserId", required=false) String var3);

    @GetMapping(value={"/ovopark-weixin/user/getUserByUnionId"})
    public BaseResult<UsersSimpleVo> getUserByUnionId(@RequestParam(value="groupId") Integer var1, @RequestParam(value="unionId") String var2);

    @PostMapping(value={"/ovopark-weixin/user/deleteUserByOtherIds"})
    public BaseResult deleteUserByOtherIds(@RequestBody UserSaveVo var1);

    @GetMapping(value={"/ovopark-weixin/user/cleanUser"})
    public BaseResult<Boolean> cleanUser(@RequestParam(value="groupId") Integer var1, @RequestParam(value="systemType") Integer var2, @RequestParam(value="logId") String var3);

    @PostMapping(value={"/ovopark-weixin/user/saveConfigure"})
    public BaseResult<SystemConfigureMo> saveConfigure(@RequestBody SystemConfigureMo var1);

    @PostMapping(value={"/ovopark-weixin/user/getExpireTimeByUsers"})
    public BaseResult<Map<Integer, String>> getExpireTimeByUsers(@RequestBody SimpleIdsMo var1);

    @GetMapping(value={"/ovopark-weixin/user/getUserByFeishuOpenId"})
    public BaseResult<UsersSimpleVo> getUserByFeishuOpenId(@RequestParam(value="groupId") Integer var1, @RequestParam(value="openId") String var2);

    @PostMapping(value={"/ovopark-weixin/user/getExpireTimeByGroupIdAndOrder"})
    public BaseResult<List<ExpireTimeMo>> getExpireTimeByGroupIdAndOrder(@RequestBody SimpleIdsMo var1);

    @PostMapping(value={"/ovopark-weixin/user/updateUsersChangeHistory"})
    public BaseResult<Boolean> updateUsersChangeHistory(@RequestParam(value="userId") Integer var1, @RequestParam(value="logId", required=false) String var2, @RequestParam(value="beforeContent", required=false) String var3, @RequestParam(value="afterContent", required=false) String var4, @RequestParam(value="wechatUser") Integer var5);

    @GetMapping(value={"/ovopark-weixin/user/getUserByUserName"})
    public BaseResult<UsersSimpleVo> getUserByUserName(@RequestParam(value="groupId", required=false) Integer var1, @RequestParam(value="userName") String var2);

    @PostMapping(value={"/ovopark-weixin/user/removeResignByIds"})
    public BaseResult removeResignByIds(@RequestBody UserSaveVo var1);

    @GetMapping(value={"/ovopark-weixin/user/getResignUserThirds"})
    public BaseResult<List<UsersSimpleVo>> getResignUserThirds();

    @GetMapping(value={"/ovopark-weixin/user/getFeishuLeaderDepartments"})
    public BaseResult<LeaderOrganizeIdsMo> getFeishuLeaderDepartments(@RequestParam(value="groupId") Integer var1, @RequestParam(value="leaderId") String var2);

    @PostMapping(value={"/ovopark-weixin/user/getFeishuLeaderDepartmentsBatch"})
    public BaseResult<Map<String, LeaderOrganizeIdsMo>> getFeishuLeaderDepartmentsBatch(@RequestParam(value="groupId") Integer var1, @RequestBody List<String> var2);
}

