/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.api.common.builder.impl;

import com.ovopark.paas.api.common.builder.GetAlgoConfigBuilder;
import com.ovopark.paas.api.entity.DetectAreaListEntity;
import com.ovopark.paas.api.entity.DetectTimeListEntity;
import com.ovopark.paas.api.entity.DeviceAlgoStatusEntity;
import com.ovopark.paas.api.entity.DeviceProductAreaEntity;
import com.ovopark.paas.api.entity.DeviceProductAreaShieldEntity;
import com.ovopark.paas.api.entity.ModelDetailEntity;
import com.ovopark.paas.api.entity.ModelVersionDetailEntity;
import com.ovopark.paas.api.entity.PassLineListEntity;
import com.ovopark.paas.api.entity.dao.AlgoRightVersionInfoDao;
import com.ovopark.paas.api.entity.dao.DeviceAlgoRelationInfoDao;
import com.ovopark.paas.api.entity.vo.DeviceStatusPojo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GetAlgoConfigListVoBuilder
extends GetAlgoConfigBuilder {
    @Override
    public GetAlgoConfigBuilder buildDefault() {
        this.model.setChnId(0);
        this.model.setEnable(0);
        this.model.setConfThreshold(Float.valueOf(0.5f));
        this.model.setHotHFileUploadUrl("");
        this.model.setHotZFileUploadUrl("");
        this.model.setHotZoomCnfUrl("");
        this.model.setSnapUploadUrl("");
        this.model.setUploadFreq(60);
        this.model.setUpSensitivity(Float.valueOf(0.6f));
        this.model.setSnapEnable(1);
        this.model.setUploadUrl("");
        this.model.setWidth(1920);
        this.model.setHeight(1080);
        this.model.setDetectTimeList(new ArrayList<DetectTimeListEntity>());
        this.model.setPassLineList(new ArrayList<PassLineListEntity>());
        this.model.setDpas(new ArrayList<DeviceProductAreaEntity>());
        this.model.setShields(new ArrayList<DeviceProductAreaShieldEntity>());
        this.model.setStartTime(0);
        this.model.setEndTime(0);
        this.model.setPassFlowUseDepTimeFlag(0);
        this.model.setNeedUpgrade(false);
        this.model.setIsGetConfig(0);
        ArrayList<DetectAreaListEntity> areaList = new ArrayList<DetectAreaListEntity>();
        DetectAreaListEntity areaInfo = DetectAreaListEntity.getDetectArea();
        areaList.add(areaInfo);
        this.model.setDetectAreaInfo(areaList);
        this.model.setShieldAreaInfo(new ArrayList<DetectAreaListEntity>());
        return this;
    }

    @Override
    public GetAlgoConfigBuilder buildModel(ModelDetailEntity modelInfo2, DeviceAlgoRelationInfoDao bindInfo, AlgoRightVersionInfoDao right) {
        if (modelInfo2 == null) {
            return this;
        }
        this.model.setModelId(modelInfo2.getId());
        this.model.setModelEnglishName(modelInfo2.getModelEnglishName());
        this.model.setModelIcon(modelInfo2.getImg());
        this.model.setAlgoName("");
        this.model.setNeedUpgrade(false);
        this.model.setConfThreshold(Float.valueOf(modelInfo2.getSensitivity().floatValue()));
        this.model.setUpSensitivity(Float.valueOf(0.85f));
        ModelVersionDetailEntity version = modelInfo2.getVersionList().get(0);
        if (right != null) {
            this.model.setLatestVersion(right.getVersion());
        }
        if (bindInfo != null) {
            List versionList = modelInfo2.getVersionList().stream().filter(m -> StringUtils.isNotEmpty((CharSequence)m.getVersion()) && m.getVersion().compareTo(bindInfo.getAlgoVersion()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(versionList)) {
                this.model.setAlgoName(this.getCodeInfo(((ModelVersionDetailEntity)versionList.get(0)).getAlgoCode()));
                this.model.setVersion(((ModelVersionDetailEntity)versionList.get(0)).getVersion());
                this.model.setUploadType(CollectionUtils.isEmpty(((ModelVersionDetailEntity)versionList.get(0)).getAlgoConfigTypes()) ? null : ((ModelVersionDetailEntity)versionList.get(0)).getAlgoConfigTypes().get(0));
                this.model.setUploadDataType(CollectionUtils.isEmpty(((ModelVersionDetailEntity)versionList.get(0)).getUploadDataTypes()) ? null : ((ModelVersionDetailEntity)versionList.get(0)).getUploadDataTypes().get(0));
            }
        } else {
            this.model.setAlgoName(this.getCodeInfo(version.getAlgoCode()));
            this.model.setUploadType(CollectionUtils.isEmpty(version.getAlgoConfigTypes()) ? null : version.getAlgoConfigTypes().get(0));
            this.model.setUploadDataType(CollectionUtils.isEmpty(version.getUploadDataTypes()) ? null : version.getUploadDataTypes().get(0));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.model.getVersion()) && StringUtils.isNotEmpty((CharSequence)this.model.getLatestVersion())) {
            this.model.setNeedUpgrade(!this.model.getVersion().equals(this.model.getLatestVersion()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.model.getAlgoName())) {
            this.model.setModelName(modelInfo2.getModelName());
        } else {
            this.model.setModelName(modelInfo2.getModelName() + "[\u5f85\u7ef4\u62a4]");
        }
        return this;
    }

    private String getCodeInfo(String code) {
        if (StringUtils.isEmpty((CharSequence)code) && code.length() != 32) {
            return null;
        }
        return code.substring(0, 21);
    }

    @Override
    public GetAlgoConfigBuilder buildDeviceStatus(DeviceStatusPojo deviceInfo, String code) {
        List statusList;
        this.model.setRunDeviceId(deviceInfo.getId());
        this.model.setIsRun(0);
        this.model.setDownloadStatus(0);
        if (CollectionUtils.isNotEmpty(deviceInfo.getDeviceAlgorithmStatusList()) && StringUtils.isNotEmpty((CharSequence)code) && CollectionUtils.isNotEmpty(statusList = deviceInfo.getDeviceAlgorithmStatusList().stream().filter(m -> m.getAlgoName().contains(code)).collect(Collectors.toList()))) {
            DeviceAlgoStatusEntity statusInfo = (DeviceAlgoStatusEntity)statusList.get(0);
            this.model.setIsRun(statusInfo.getStatus().compareTo(1) == 0 ? 1 : 0);
            this.model.setDownloadStatus(statusInfo.getDownloadStatus());
        }
        return this;
    }

    @Override
    public GetAlgoConfigBuilder buildConfigMark(Integer code, Integer canBind) {
        this.model.setModelStatus(code);
        this.model.setCanBind(canBind);
        return this;
    }
}

